/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletContext
implements ServletContext {
    private static final Logger log = LoggerFactory.getLogger(MockServletContext.class);
    private final Application application;
    private final ValueMap attributes = new ValueMap();
    private final ValueMap initParameters = new ValueMap();
    private final ValueMap mimeTypes = new ValueMap();
    private File webappRoot;

    public MockServletContext(Application application, String path) {
        this.application = application;
        this.webappRoot = null;
        if (path != null) {
            this.webappRoot = new File(path);
            if (!this.webappRoot.exists() || !this.webappRoot.isDirectory()) {
                log.warn("WARNING: The webapp root directory is invalid: " + path);
                this.webappRoot = null;
            }
        }
        File file = new File("target/work/");
        file.mkdirs();
        this.attributes.put("javax.servlet.context.tempdir", (Object)file);
        this.mimeTypes.put("html", (Object)"text/html");
        this.mimeTypes.put("htm", (Object)"text/html");
        this.mimeTypes.put("css", (Object)"text/css");
        this.mimeTypes.put("xml", (Object)"text/xml");
        this.mimeTypes.put("js", (Object)"text/javascript");
        this.mimeTypes.put("gif", (Object)"image/gif");
        this.mimeTypes.put("jpg", (Object)"image/jpeg");
        this.mimeTypes.put("png", (Object)"image/png");
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, (Object)value);
    }

    public void addMimeType(String fileExtension, String mimeType) {
        this.mimeTypes.put(fileExtension, (Object)mimeType);
    }

    public Object getAttribute(String name) {
        return this.attributes.get((Object)name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public ServletContext getContext(String name) {
        return this;
    }

    public String getInitParameter(String name) {
        return this.initParameters.getString(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index == name.length() - 1) {
            return null;
        }
        return this.mimeTypes.getString(name.substring(index + 1));
    }

    public int getMinorVersion() {
        return 5;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getRequestDispatcher(name);
    }

    public String getRealPath(String name) {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        return f.getPath();
    }

    public RequestDispatcher getRequestDispatcher(final String name) {
        return new RequestDispatcher(){

            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("FORWARD TO RESOURCE: " + name);
            }

            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("INCLUDE OF RESOURCE: " + name);
            }
        };
    }

    public URL getResource(String name) throws MalformedURLException {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        return f.toURI().toURL();
    }

    public InputStream getResourceAsStream(String name) {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Set<String> getResourcePaths(String name) {
        if (this.webappRoot == null) {
            return new HashSet<String>();
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String[] elements = null;
        elements = name.trim().length() == 0 ? new String[]{} : name.split("/");
        File current = this.webappRoot;
        for (String element : elements) {
            File[] files = current.listFiles();
            boolean match = false;
            for (File file : files) {
                if (!file.getName().equals(element) || !file.isDirectory()) continue;
                current = file;
                match = true;
                break;
            }
            if (match) continue;
            return null;
        }
        File[] files = current.listFiles();
        HashSet<String> result = new HashSet<String>();
        int stripLength = this.webappRoot.getPath().length();
        for (File file : files) {
            String s = file.getPath().substring(stripLength).replace('\\', '/');
            if (file.isDirectory()) {
                s = s + "/";
            }
            result.add(s);
        }
        return result;
    }

    public String getServerInfo() {
        return "Wicket Mock Test Environment v1.0";
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public String getServletContextName() {
        return this.application.getName();
    }

    public Enumeration<String> getServletNames() {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return null;
    }

    public void log(Exception e, String msg) {
        log.error(msg, (Throwable)e);
    }

    public void log(String msg) {
        log.info(msg);
    }

    public void log(String msg, Throwable cause) {
        log.error(msg, cause);
    }

    public void removeAttribute(String name) {
        this.attributes.remove((Object)name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public String getContextPath() {
        return "";
    }
}

