/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import org.apache.wicket.Session;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.HttpsRequestChecker;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Args;

public class HttpsMapper
implements IRequestMapper {
    private final IRequestMapper delegate;
    private final HttpsConfig httpsConfig;
    private final HttpsRequestChecker checker;

    public HttpsMapper(IRequestMapper delegate, HttpsConfig httpsConfig) {
        Args.notNull((Object)delegate, (String)"delegate");
        Args.notNull((Object)httpsConfig, (String)"httpsConfig");
        this.delegate = delegate;
        this.httpsConfig = httpsConfig;
        this.checker = new HttpsRequestChecker();
    }

    public IRequestHandler mapRequest(Request request) {
        IRequestHandler requestHandler = this.delegate.mapRequest(request);
        if (requestHandler != null) {
            IRequestHandler httpsHandler = this.checker.checkSecureIncoming(requestHandler, this.httpsConfig);
            if (this.httpsConfig.isPreferStateful()) {
                Session.get().bind();
            }
            requestHandler = httpsHandler;
        }
        return requestHandler;
    }

    public int getCompatibilityScore(Request request) {
        return this.delegate.getCompatibilityScore(request);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.delegate.mapHandler(requestHandler);
        switch (this.checker.getProtocol(requestHandler)) {
            case HTTP: {
                url.setProtocol("http");
                url.setPort(Integer.valueOf(this.httpsConfig.getHttpPort()));
                break;
            }
            case HTTPS: {
                url.setProtocol("https");
                url.setPort(Integer.valueOf(this.httpsConfig.getHttpsPort()));
            }
        }
        return url;
    }
}

