/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.apache.wicket.util.template.TextTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTemplateResourceReference
extends ResourceReference
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final TextTemplate textTemplate;
    private final IModel<Map<String, Object>> variablesModel;
    private IResource resource;

    public TextTemplateResourceReference(Class<?> scope, String fileName, IModel<Map<String, Object>> variablesModel) {
        this(scope, fileName, "text", PackageTextTemplate.DEFAULT_ENCODING, variablesModel);
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, IModel<Map<String, Object>> variablesModel) {
        this(scope, fileName, contentType, PackageTextTemplate.DEFAULT_ENCODING, variablesModel);
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, String encoding, IModel<Map<String, Object>> variablesModel) {
        this(scope, fileName, contentType, encoding, variablesModel, null, null, null);
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, String encoding, IModel<Map<String, Object>> variablesModel, Locale locale, String style, String variation) {
        super(scope, fileName, locale, style, variation);
        this.textTemplate = new PackageTextTemplate(scope, fileName, contentType, encoding);
        this.variablesModel = variablesModel;
        if (Application.exists()) {
            Application.get().getResourceReferenceRegistry().registerResourceReference(this);
        }
    }

    @Override
    public IResource getResource() {
        if (this.resource != null) {
            return this.resource;
        }
        String stringValue = this.textTemplate.asString(this.variablesModel.getObject());
        this.variablesModel.detach();
        StringResourceStream resourceStream = new StringResourceStream((CharSequence)stringValue, this.textTemplate.getContentType());
        resourceStream.setLastModified(this.textTemplate.lastModifiedTime());
        this.resource = new ResourceStreamResource((IResourceStream)resourceStream);
        return this.resource;
    }
}

