/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.request.RequestHandlerStack;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPageFactory
implements IPageFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageFactory.class);
    private final Map<Class<?>, Constructor<?>> constructorForClass = Generics.newConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> pageToBookmarkableCache = new ConcurrentHashMap<String, Boolean>();

    @Override
    public final <C extends IRequestablePage> Page newPage(Class<C> pageClass) {
        try {
            Constructor<C> constructor = pageClass.getConstructor(null);
            return this.processPage(this.newPage(constructor, null), null);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = this.constructor(pageClass, PageParameters.class);
            if (constructor != null) {
                PageParameters pp = new PageParameters();
                return this.processPage(this.newPage(constructor, (Object)pp), pp);
            }
            throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does not have a visible default contructor.", e);
        }
    }

    @Override
    public final <C extends IRequestablePage> Page newPage(Class<C> pageClass, PageParameters parameters) {
        Constructor<?> constructor = this.constructor(pageClass, PageParameters.class);
        if (constructor != null) {
            return this.processPage(this.newPage(constructor, (Object)parameters), parameters);
        }
        return this.processPage((Page)this.newPage((Class)pageClass), parameters);
    }

    private final <C extends IRequestablePage> Constructor<?> constructor(Class<C> pageClass, Class<PageParameters> argumentType) {
        Constructor<Object> constructor = this.constructorForClass.get(pageClass);
        if (constructor == null) {
            try {
                constructor = pageClass.getConstructor(argumentType);
                this.constructorForClass.put(pageClass, constructor);
                if (log.isDebugEnabled()) {
                    log.debug("Found constructor for Page of type '{}' and argument of type '{}'.", pageClass, argumentType);
                }
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Page of type '{}' has not visible constructor with an argument of type '{}'.", pageClass, argumentType);
                }
                return null;
            }
        }
        return constructor;
    }

    private final Page newPage(Constructor<?> constructor, Object argument) {
        try {
            if (argument != null) {
                return (Page)constructor.newInstance(argument);
            }
            return (Page)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RequestHandlerStack.ReplaceHandlerException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof MarkupException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
    }

    private Page processPage(Page page, PageParameters pageParameters) {
        if (pageParameters != null && page.getPageParameters() != pageParameters) {
            page.getPageParameters().overwriteWith(pageParameters);
        }
        page.setWasCreatedBookmarkable(true);
        return page;
    }

    private String createDescription(Constructor<?> constructor, Object argument) {
        String msg = argument != null ? "Can't instantiate page using constructor '" + constructor + "' and argument '" + argument : "Can't instantiate page using constructor '" + constructor;
        return msg + "'. Might be it doesn't exist, may be it is not visible (public).";
    }

    @Override
    public <C extends IRequestablePage> boolean isBookmarkable(Class<C> pageClass) {
        Boolean bookmarkable = (Boolean)this.pageToBookmarkableCache.get(pageClass.getName());
        if (bookmarkable == null) {
            try {
                if (pageClass.getConstructor(new Class[0]) != null) {
                    bookmarkable = Boolean.TRUE;
                }
            }
            catch (Exception ignore) {
                try {
                    if (pageClass.getConstructor(PageParameters.class) != null) {
                        bookmarkable = Boolean.TRUE;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (bookmarkable == null) {
                bookmarkable = Boolean.FALSE;
            }
            this.pageToBookmarkableCache.put(pageClass.getName(), bookmarkable);
        }
        return bookmarkable;
    }
}

