/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.util.Locale;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolverConverter
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final IConverterLocator converterSupplier;
    private final Locale locale;

    public PropertyResolverConverter(IConverterLocator converterSupplier, Locale locale) {
        this.converterSupplier = converterSupplier;
        this.locale = locale;
    }

    public <T> T convert(Object object, Class<T> clz) {
        Object result;
        if (object == null) {
            return null;
        }
        if (clz.isAssignableFrom(object.getClass())) {
            Object result2 = object;
            return (T)result2;
        }
        IConverter<T> converter = this.converterSupplier.getConverter(clz);
        if (object instanceof String) {
            return (T)converter.convertToObject((String)object, this.locale);
        }
        if (clz == String.class) {
            String result3 = this.convertToString(object, this.locale);
            return (T)result3;
        }
        try {
            result = Objects.convertValue((Object)object, clz);
        }
        catch (RuntimeException ex) {
            result = null;
        }
        if (result == null) {
            String tmp = this.convertToString(object, this.locale);
            result = converter.convertToObject(tmp, this.locale);
        }
        return (T)result;
    }

    protected <C> String convertToString(C object, Locale locale) {
        Class<?> type = object.getClass();
        IConverter<?> converterForObj = this.converterSupplier.getConverter(type);
        return converterForObj.convertToString(object, locale);
    }
}

