/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.io.Serializable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaximumValidator<Z extends Comparable<Z> & Serializable>
extends Behavior
implements IValidator<Z> {
    private static final long serialVersionUID = 1L;
    private final Z maximum;

    public MaximumValidator(Z maximum) {
        this.maximum = maximum;
    }

    @Override
    public void validate(IValidatable<Z> validatable) {
        Comparable value = (Comparable)validatable.getValue();
        if (value.compareTo(this.maximum) > 0) {
            ValidationError error = new ValidationError();
            error.addMessageKey(this.resourceKey());
            error.setVariable("maximum", this.maximum);
            validatable.error(error);
        }
    }

    public Z getMaximum() {
        return this.maximum;
    }

    protected String resourceKey() {
        return Classes.simpleName(this.getClass());
    }
}

