/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.lang.ref.WeakReference;
import java.util.Locale;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.MarkupType;

public class ContainerInfo {
    private final WeakReference<Class<?>> containerClassRef;
    private final Locale locale;
    private final String style;
    private final String variation;
    private final MarkupType markupType;

    public ContainerInfo(MarkupContainer container) {
        this(container.getClass(), container.getLocale(), container.getStyle(), container.getVariation(), container.getMarkupType());
    }

    public ContainerInfo(Class<?> containerClass, MarkupContainer container) {
        this(containerClass != null ? containerClass : container.getClass(), container.getLocale(), container.getStyle(), container.getVariation(), container.getMarkupType());
    }

    public ContainerInfo(Class<?> containerClass, Locale locale, String style, String variation, MarkupType markupType) {
        this.containerClassRef = new WeakReference(containerClass);
        this.locale = locale;
        this.style = style;
        this.variation = variation;
        this.markupType = markupType;
    }

    public Class<?> getContainerClass() {
        return (Class)this.containerClassRef.get();
    }

    public String getFileExtension() {
        return this.markupType != null ? this.markupType.getExtension() : null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getStyle() {
        return this.style;
    }

    public String getVariation() {
        return this.variation;
    }

    public String toString() {
        Class classRef = (Class)this.containerClassRef.get();
        return (classRef != null ? classRef.getName() : "null class") + ":" + this.locale + ":" + this.style + ":" + this.markupType;
    }
}

