/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.AbstractCheckSelector;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class CheckGroupSelector
extends AbstractCheckSelector {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavaScriptResourceReference(CheckGroupSelector.class, "CheckGroupSelector.js");
    private CheckGroup<?> group;

    public CheckGroupSelector(String id) {
        this(id, (CheckGroup<?>)null);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(JavaScriptHeaderItem.forReference(JS));
    }

    public CheckGroupSelector(String id, CheckGroup<?> group) {
        super(id);
        this.group = group;
        this.setOutputMarkupId(true);
    }

    private CheckGroup<?> getGroup() {
        CheckGroup group = this.group;
        if (group == null) {
            this.group = group = this.findParent(CheckGroup.class);
        }
        return group;
    }

    @Override
    protected void onInitialize() {
        Form<?> form;
        super.onInitialize();
        CheckGroup<?> group = this.getGroup();
        if (group != null && (form = group.getForm()) != null) {
            form.setOutputMarkupId(true);
        }
    }

    @Override
    public boolean isEnabled() {
        CheckGroup<?> group = this.getGroup();
        if (group == null) {
            return true;
        }
        return group.isEnableAllowed() && group.isEnabledInHierarchy();
    }

    @Override
    protected CharSequence getFindCheckboxesFunction() {
        CheckGroup<?> group = this.getGroup();
        if (group == null) {
            throw new WicketRuntimeException("CheckGroupSelector component [" + this.getPath() + "] cannot find its parent CheckGroup. All CheckGroupSelector components must be a child of or below in the hierarchy of a CheckGroup component.");
        }
        return "Wicket.CheckboxSelector.Group.findCheckboxesFunction('" + group.getForm().getRootForm().getMarkupId() + "','" + group.getInputName() + "')";
    }
}

