/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class FormTester {
    private final ChoiceSelectorFactory choiceSelectorFactory = new ChoiceSelectorFactory();
    private boolean closed = false;
    private final String path;
    private final BaseWicketTester tester;
    private final Form<?> workingForm;
    private boolean clearFeedbackMessagesBeforeSubmit = true;

    protected FormTester(String path, Form<?> workingForm, BaseWicketTester wicketTester, final boolean fillBlankString) {
        this.path = path;
        this.workingForm = workingForm;
        this.tester = wicketTester;
        workingForm.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (!formComponent.isVisibleInHierarchy() || !formComponent.isEnabledInHierarchy()) {
                    return;
                }
                String[] values = FormTester.getInputValue(formComponent);
                if (formComponent instanceof AbstractTextComponent && values.length == 0 && fillBlankString) {
                    FormTester.this.setFormComponentValue(formComponent, "");
                }
                for (String value : values) {
                    FormTester.this.addFormComponentValue(formComponent, value);
                }
            }
        });
        workingForm.detach();
    }

    public static String[] getInputValue(FormComponent<?> formComponent) {
        if (!formComponent.isVisibleInHierarchy() || !formComponent.isEnabledInHierarchy()) {
            return new String[0];
        }
        if (formComponent instanceof AbstractTextComponent) {
            return new String[]{FormTester.getFormComponentValue(formComponent)};
        }
        if (formComponent instanceof DropDownChoice || formComponent instanceof RadioChoice || formComponent instanceof CheckBox) {
            return new String[]{FormTester.getFormComponentValue(formComponent)};
        }
        if (formComponent instanceof ListMultipleChoice) {
            return FormTester.getFormComponentValue(formComponent).split(";");
        }
        if (formComponent instanceof CheckGroup) {
            final Collection checkGroupValues = (Collection)formComponent.getDefaultModelObject();
            final ArrayList result = new ArrayList();
            formComponent.visitChildren(Check.class, new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    if (checkGroupValues.contains(component.getDefaultModelObject())) {
                        result.add(FormTester.getFormComponentValue((Check)component));
                    }
                }
            });
            return result.toArray(new String[result.size()]);
        }
        if (formComponent instanceof RadioGroup) {
            final Object value = formComponent.getDefaultModelObject();
            String result = null;
            if (value != null) {
                result = formComponent.visitChildren(Radio.class, new IVisitor<Component, String>(){

                    public void component(Component component, IVisit<String> visit) {
                        if (value.equals(component.getDefaultModelObject())) {
                            visit.stop((Object)FormTester.getFormComponentValue((Radio)component));
                        } else {
                            visit.dontGoDeeper();
                        }
                    }
                });
            }
            if (result == null) {
                return new String[0];
            }
            return new String[]{result};
        }
        return new String[0];
    }

    private static String getFormComponentValue(FormComponent<?> formComponent) {
        boolean oldEscape = formComponent.getEscapeModelStrings();
        formComponent.setEscapeModelStrings(false);
        String val = formComponent.getValue();
        formComponent.setEscapeModelStrings(oldEscape);
        return val;
    }

    private static String getFormComponentValue(Check<?> formComponent) {
        boolean oldEscape = formComponent.getEscapeModelStrings();
        formComponent.setEscapeModelStrings(false);
        String val = formComponent.getValue();
        formComponent.setEscapeModelStrings(oldEscape);
        return val;
    }

    private static String getFormComponentValue(Radio<?> formComponent) {
        boolean oldEscape = formComponent.getEscapeModelStrings();
        formComponent.setEscapeModelStrings(false);
        String val = formComponent.getValue();
        formComponent.setEscapeModelStrings(oldEscape);
        return val;
    }

    public Form<?> getForm() {
        return this.workingForm;
    }

    public String getTextComponentValue(String id) {
        Component c = this.getForm().get(id);
        if (c instanceof AbstractTextComponent) {
            return ((AbstractTextComponent)c).getValue();
        }
        return null;
    }

    public FormTester select(String formComponentId, int index) {
        this.checkClosed();
        FormComponent component = (FormComponent)this.workingForm.get(formComponentId);
        ChoiceSelector choiceSelector = this.choiceSelectorFactory.create(component);
        choiceSelector.doSelect(index);
        try {
            Method wantOnSelectionChangedNotificationsMethod = component.getClass().getDeclaredMethod("wantOnSelectionChangedNotifications", new Class[0]);
            try {
                wantOnSelectionChangedNotificationsMethod.setAccessible(true);
                boolean wantOnSelectionChangedNotifications = (Boolean)wantOnSelectionChangedNotificationsMethod.invoke((Object)component, new Object[0]);
                if (wantOnSelectionChangedNotifications) {
                    this.tester.invokeListener(component, IOnChangeListener.INTERFACE);
                }
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        return this;
    }

    public FormTester selectMultiple(String formComponentId, int[] indexes) {
        return this.selectMultiple(formComponentId, indexes, false);
    }

    public FormTester selectMultiple(String formComponentId, int[] indexes, boolean replace) {
        this.checkClosed();
        if (replace) {
            this.setValue(formComponentId, "");
        }
        ChoiceSelector choiceSelector = this.choiceSelectorFactory.createForMultiple((FormComponent)this.workingForm.get(formComponentId));
        for (int index : indexes) {
            choiceSelector.doSelect(index);
        }
        return this;
    }

    public FormTester setValue(String formComponentId, String value) {
        Component component = this.workingForm.get(formComponentId);
        Assert.assertNotNull((String)("Unable to set value. Couldn't find component with name: " + formComponentId), (Object)component);
        return this.setValue(component, value);
    }

    public FormTester setValue(Component formComponent, String value) {
        Args.notNull((Object)formComponent, (String)"formComponent");
        this.checkClosed();
        if (formComponent instanceof IFormSubmittingComponent) {
            this.setFormSubmittingComponentValue((IFormSubmittingComponent)((Object)formComponent), value);
        } else if (formComponent instanceof FormComponent) {
            this.setFormComponentValue((FormComponent)formComponent, value);
        } else {
            this.fail("Component with id: " + formComponent.getId() + " is not a FormComponent");
        }
        return this;
    }

    public FormTester setValue(String checkBoxId, boolean value) {
        return this.setValue(checkBoxId, Boolean.toString(value));
    }

    public FormTester setFile(String formComponentId, File file, String contentType) {
        this.checkClosed();
        FormComponent formComponent = (FormComponent)this.workingForm.get(formComponentId);
        if (!(formComponent instanceof FileUploadField)) {
            this.fail("'" + formComponentId + "' is not " + "a FileUploadField. You can only attach a file to form " + "component of this type.");
        }
        MockHttpServletRequest servletRequest = this.tester.getRequest();
        servletRequest.addFile(formComponent.getInputName(), file, contentType);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormTester submit() {
        this.checkClosed();
        try {
            if (this.clearFeedbackMessagesBeforeSubmit) {
                this.tester.clearFeedbackMessages();
            }
            this.tester.getRequest().setUseMultiPartContentType(this.workingForm.isMultiPart());
            this.tester.submitForm(this.path);
        }
        finally {
            this.closed = true;
        }
        return this;
    }

    public boolean isClearFeedbackMessagesBeforeSubmit() {
        return this.clearFeedbackMessagesBeforeSubmit;
    }

    public FormTester setClearFeedbackMessagesBeforeSubmit(boolean clearFeedbackMessagesBeforeSubmit) {
        this.clearFeedbackMessagesBeforeSubmit = clearFeedbackMessagesBeforeSubmit;
        return this;
    }

    public FormTester submit(String buttonComponentId) {
        this.setValue(buttonComponentId, "marked");
        return this.submit();
    }

    public FormTester submit(Component buttonComponent) {
        Args.notNull((Object)buttonComponent, (String)"buttonComponent");
        this.setValue(buttonComponent, "marked");
        return this.submit();
    }

    public FormTester submitLink(String path, boolean pageRelative) {
        if (pageRelative) {
            this.tester.clickLink(path, false);
        } else {
            path = this.path + ":" + path;
            this.tester.clickLink(path, false);
        }
        return this;
    }

    private FormTester addFormComponentValue(FormComponent<?> formComponent, String value) {
        if (this.parameterExist(formComponent)) {
            List<StringValue> values = this.tester.getRequest().getPostParameters().getParameterValues(formComponent.getInputName());
            HashSet<String> all = new HashSet<String>();
            for (StringValue stringValue : values) {
                all.add(stringValue.toString());
            }
            all.add(value);
            values = new ArrayList<StringValue>();
            for (String string : all) {
                values.add(StringValue.valueOf((String)string));
            }
            this.tester.getRequest().getPostParameters().setParameterValues(formComponent.getInputName(), values);
        } else {
            this.setFormComponentValue(formComponent, value);
        }
        return this;
    }

    private void checkClosed() {
        if (this.closed) {
            this.fail("'" + this.path + "' already submitted. Note that FormTester " + "is allowed to submit only once");
        }
    }

    private boolean parameterExist(FormComponent<?> formComponent) {
        String parameter = this.tester.getRequest().getPostParameters().getParameterValue(formComponent.getInputName()).toString();
        return parameter != null && parameter.trim().length() > 0;
    }

    private void setFormComponentValue(FormComponent<?> formComponent, String value) {
        this.tester.getRequest().getPostParameters().setParameterValue(formComponent.getInputName(), value);
    }

    private void setFormSubmittingComponentValue(IFormSubmittingComponent component, String value) {
        this.tester.getRequest().getPostParameters().setParameterValue(component.getInputName(), value);
    }

    private void fail(String message) {
        throw new WicketRuntimeException(message);
    }

    private class ChoiceSelectorFactory {
        private ChoiceSelectorFactory() {
        }

        protected ChoiceSelector create(FormComponent<?> formComponent) {
            if (formComponent == null) {
                FormTester.this.fail("Trying to select on null component.");
            }
            if (formComponent instanceof RadioGroup || formComponent instanceof DropDownChoice || formComponent instanceof RadioChoice) {
                return new SingleChoiceSelector(formComponent);
            }
            if (this.allowMultipleChoice(formComponent)) {
                return new MultipleChoiceSelector(formComponent);
            }
            FormTester.this.fail("Selecting on the component:'" + formComponent.getPath() + "' is not supported.");
            return null;
        }

        protected ChoiceSelector createForMultiple(FormComponent<?> formComponent) {
            return new MultipleChoiceSelector(formComponent);
        }

        private boolean allowMultipleChoice(FormComponent<?> formComponent) {
            return formComponent instanceof CheckGroup || formComponent instanceof ListMultipleChoice;
        }

        private final class SingleChoiceSelector
        extends ChoiceSelector {
            protected SingleChoiceSelector(FormComponent<?> formComponent) {
                super(formComponent);
            }

            @Override
            protected void assignValueToFormComponent(FormComponent<?> formComponent, String value) {
                FormTester.this.setFormComponentValue(formComponent, value);
            }
        }

        private final class MultipleChoiceSelector
        extends ChoiceSelector {
            protected MultipleChoiceSelector(FormComponent<?> formComponent) {
                super(formComponent);
                if (!ChoiceSelectorFactory.this.allowMultipleChoice(formComponent)) {
                    FormTester.this.fail("Component:'" + formComponent.getPath() + "' Does not support multiple selection.");
                }
            }

            @Override
            protected void assignValueToFormComponent(FormComponent<?> formComponent, String value) {
                FormTester.this.addFormComponentValue(formComponent, value);
            }
        }
    }

    protected abstract class ChoiceSelector {
        private final FormComponent<?> formComponent;

        protected ChoiceSelector(FormComponent<?> formComponent) {
            this.formComponent = formComponent;
        }

        protected abstract void assignValueToFormComponent(FormComponent<?> var1, String var2);

        public String getChoiceValueForIndex(int index) {
            if (this.formComponent instanceof RadioGroup) {
                Radio foundRadio = (Radio)this.formComponent.visitChildren(Radio.class, new SearchOptionByIndexVisitor(index));
                if (foundRadio == null) {
                    FormTester.this.fail("RadioGroup " + this.formComponent.getPath() + " does not have index:" + index);
                    return null;
                }
                return foundRadio.getValue();
            }
            if (this.formComponent instanceof CheckGroup) {
                Check foundCheck = (Check)this.formComponent.visitChildren(Check.class, new SearchOptionByIndexVisitor(index));
                if (foundCheck == null) {
                    FormTester.this.fail("CheckGroup " + this.formComponent.getPath() + " does not have index:" + index);
                    return null;
                }
                return foundCheck.getValue();
            }
            String idValue = this.selectAbstractChoice(this.formComponent, index);
            if (idValue == null) {
                FormTester.this.fail(this.formComponent.getPath() + " is not a selectable Component.");
                return null;
            }
            return idValue;
        }

        protected final void doSelect(int index) {
            String value = this.getChoiceValueForIndex(index);
            this.assignValueToFormComponent(this.formComponent, value);
        }

        private String selectAbstractChoice(FormComponent<?> formComponent, int index) {
            try {
                Method getChoicesMethod = formComponent.getClass().getMethod("getChoices", null);
                getChoicesMethod.setAccessible(true);
                List choices = (List)getChoicesMethod.invoke(formComponent, (Object[])null);
                Method getChoiceRendererMethod = formComponent.getClass().getMethod("getChoiceRenderer", null);
                getChoiceRendererMethod.setAccessible(true);
                IChoiceRenderer choiceRenderer = (IChoiceRenderer)getChoiceRendererMethod.invoke(formComponent, (Object[])null);
                return choiceRenderer.getIdValue(choices.get(index), index);
            }
            catch (SecurityException e) {
                throw new WicketRuntimeException("unexpect select failure", e);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                throw new WicketRuntimeException("unexpect select failure", e);
            }
            catch (InvocationTargetException e) {
                throw new WicketRuntimeException("unexpect select failure", e);
            }
        }

        private final class SearchOptionByIndexVisitor
        implements IVisitor<Component, Component> {
            int count = 0;
            private final int index;

            private SearchOptionByIndexVisitor(int index) {
                this.index = index;
            }

            public void component(Component component, IVisit<Component> visit) {
                if (this.count == this.index) {
                    visit.stop((Object)component);
                } else {
                    ++this.count;
                }
            }
        }
    }
}

