/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.core.request.mapper.BookmarkableMapper;
import org.apache.wicket.core.request.mapper.BufferedResponseMapper;
import org.apache.wicket.core.request.mapper.HomePageMapper;
import org.apache.wicket.core.request.mapper.PageInstanceMapper;
import org.apache.wicket.core.request.mapper.ResourceReferenceMapper;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.CompoundRequestMapper;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.util.ClassProvider;
import org.apache.wicket.util.IProvider;

public class SystemMapper
extends CompoundRequestMapper {
    private final Application application;

    public SystemMapper(Application application) {
        this.application = application;
        this.add(new PageInstanceMapper());
        this.add(new BookmarkableMapper());
        this.add(new HomePageMapper(new HomePageProvider(application)));
        this.add((IRequestMapper)new ResourceReferenceMapper((IPageParametersEncoder)new PageParametersEncoder(), new ParentFolderPlaceholderProvider(application), this.getResourceCachingStrategy()));
        this.add(RestartResponseAtInterceptPageException.MAPPER);
        this.add(new BufferedResponseMapper());
    }

    private IProvider<IResourceCachingStrategy> getResourceCachingStrategy() {
        return new IProvider<IResourceCachingStrategy>(){

            public IResourceCachingStrategy get() {
                return SystemMapper.this.application.getResourceSettings().getCachingStrategy();
            }
        };
    }

    private static class HomePageProvider<C extends IRequestablePage>
    extends ClassProvider<C> {
        private final Application application;

        private HomePageProvider(Application application) {
            super(null);
            this.application = application;
        }

        public Class<C> get() {
            Class<? extends Page> homePage = this.application.getHomePage();
            return homePage;
        }
    }

    private static class ParentFolderPlaceholderProvider
    implements IProvider<String> {
        private final Application application;

        public ParentFolderPlaceholderProvider(Application application) {
            this.application = application;
        }

        public String get() {
            return this.application.getResourceSettings().getParentFolderPlaceholder();
        }
    }
}

