/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authentication.strategy;

import org.apache.wicket.Application;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationStrategy
implements IAuthenticationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthenticationStrategy.class);
    private final String cookieKey;
    private final String VALUE_SEPARATOR = "-sep-";
    private CookieUtils cookieUtils;
    private ICrypt crypt;

    public DefaultAuthenticationStrategy(String cookieKey) {
        this.cookieKey = (String)Args.notEmpty((CharSequence)cookieKey, (String)"cookieKey");
    }

    protected CookieUtils getCookieUtils() {
        if (this.cookieUtils == null) {
            this.cookieUtils = new CookieUtils();
        }
        return this.cookieUtils;
    }

    protected ICrypt getCrypt() {
        if (this.crypt == null) {
            this.crypt = Application.get().getSecuritySettings().getCryptFactory().newCrypt();
        }
        return this.crypt;
    }

    @Override
    public String[] load() {
        String value = this.getCookieUtils().load(this.cookieKey);
        if (!Strings.isEmpty((CharSequence)value)) {
            try {
                value = this.getCrypt().decryptUrlSafe(value);
            }
            catch (RuntimeException e) {
                logger.info("Error decrypting login cookie: {}. The cookie will be deleted. Possible cause is that a session-relative encryption key was used to encrypt this cookie while this decryption attempt is happening in a different session, eg user coming back to the application after session expiration", (Object)this.cookieKey);
                this.getCookieUtils().remove(this.cookieKey);
                value = null;
            }
            if (!Strings.isEmpty((CharSequence)value)) {
                String username = null;
                String password = null;
                String[] values = value.split("-sep-");
                if (values.length > 0 && !Strings.isEmpty((CharSequence)values[0])) {
                    username = values[0];
                }
                if (values.length > 1 && !Strings.isEmpty((CharSequence)values[1])) {
                    password = values[1];
                }
                return new String[]{username, password};
            }
        }
        return null;
    }

    @Override
    public void save(String username, String password) {
        String value = username + "-sep-" + password;
        String encryptedValue = this.getCrypt().encryptUrlSafe(value);
        this.getCookieUtils().save(this.cookieKey, encryptedValue);
    }

    @Override
    public void remove() {
        this.getCookieUtils().remove(this.cookieKey);
    }
}

