/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.Application;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractComponentMapper
extends AbstractMapper
implements IRequestMapper {
    protected IMapperContext getContext() {
        return Application.get().getMapperContext();
    }

    protected String requestListenerInterfaceToString(RequestListenerInterface listenerInterface) {
        Args.notNull((Object)listenerInterface, (String)"listenerInterface");
        return this.getContext().requestListenerInterfaceToString(listenerInterface);
    }

    protected RequestListenerInterface requestListenerInterfaceFromString(String interfaceName) {
        Args.notEmpty((CharSequence)interfaceName, (String)"interfaceName");
        return this.getContext().requestListenerInterfaceFromString(interfaceName);
    }

    protected PageComponentInfo getPageComponentInfo(Url url) {
        if (url == null) {
            throw new IllegalStateException("Argument 'url' may not be null.");
        }
        for (Url.QueryParameter queryParameter : url.getQueryParameters()) {
            PageComponentInfo pageComponentInfo;
            if (!Strings.isEmpty((CharSequence)queryParameter.getValue()) || (pageComponentInfo = PageComponentInfo.parse((String)queryParameter.getName())) == null) continue;
            return pageComponentInfo;
        }
        return null;
    }

    protected void encodePageComponentInfo(Url url, PageComponentInfo info) {
        String s;
        Args.notNull((Object)url, (String)"url");
        if (info != null && !Strings.isEmpty((CharSequence)(s = info.toString()))) {
            Url.QueryParameter parameter = new Url.QueryParameter(s, "");
            url.getQueryParameters().add(parameter);
        }
    }

    protected Class<? extends IRequestablePage> getPageClass(String name) {
        Args.notEmpty((CharSequence)name, (String)"name");
        return WicketObjects.resolveClass(name);
    }

    protected void removeMetaParameter(Url urlCopy) {
        String pageComponentInfoCandidate = ((Url.QueryParameter)urlCopy.getQueryParameters().get(0)).getName();
        if (PageComponentInfo.parse((String)pageComponentInfoCandidate) != null) {
            urlCopy.getQueryParameters().remove(0);
        }
    }
}

