/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public final class FeedbackCollector {
    private final Component component;
    private boolean includeSession = true;
    private boolean recursive = true;

    public FeedbackCollector() {
        this(null);
    }

    public FeedbackCollector(Component component) {
        this.component = component;
    }

    public FeedbackCollector setIncludeSession(boolean value) {
        this.includeSession = value;
        return this;
    }

    public FeedbackCollector setRecursive(boolean value) {
        this.recursive = value;
        return this;
    }

    public List<FeedbackMessage> collect() {
        return this.collect(IFeedbackMessageFilter.ALL);
    }

    public List<FeedbackMessage> collect(final IFeedbackMessageFilter filter) {
        final ArrayList<FeedbackMessage> messages = new ArrayList<FeedbackMessage>();
        if (this.includeSession && Session.exists()) {
            messages.addAll(Session.get().getFeedbackMessages().messages(filter));
        }
        if (this.component != null && this.component.hasFeedbackMessage()) {
            messages.addAll(this.component.getFeedbackMessages().messages(filter));
        }
        if (this.component != null && this.recursive && this.component instanceof MarkupContainer) {
            ((MarkupContainer)this.component).visitChildren(new IVisitor<Component, Void>(){

                public void component(Component object, IVisit<Void> visit) {
                    if (object.hasFeedbackMessage()) {
                        messages.addAll(object.getFeedbackMessages().messages(filter));
                    }
                }
            });
        }
        return messages;
    }
}

