/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssContentHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.CssUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class CssHeaderItem
extends HeaderItem {
    private final String condition;

    protected CssHeaderItem(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference) {
        return CssHeaderItem.forReference(reference, null);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, String media) {
        return CssHeaderItem.forReference(reference, null, media);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String media) {
        return CssHeaderItem.forReference(reference, pageParameters, media, null);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String media, String condition) {
        return new CssReferenceHeaderItem(reference, pageParameters, media, condition);
    }

    public static CssContentHeaderItem forCSS(CharSequence css, String id) {
        return CssHeaderItem.forCSS(css, id, null);
    }

    public static CssContentHeaderItem forCSS(CharSequence css, String id, String condition) {
        return new CssContentHeaderItem(css, id, condition);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url) {
        return CssHeaderItem.forUrl(url, null);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url, String media) {
        return CssHeaderItem.forUrl(url, media, null);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url, String media, String condition) {
        return new CssUrlReferenceHeaderItem(url, media, condition);
    }

    protected final void internalRenderCSSReference(Response response, String url, String media, String condition) {
        boolean hasCondition;
        Args.notEmpty((CharSequence)url, (String)"url");
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)condition);
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)condition);
            response.write((CharSequence)"]>");
        }
        CssUtils.writeLinkUrl(response, url, media);
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->");
        }
        response.write((CharSequence)"\n");
    }
}

