/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import org.apache.wicket.core.util.string.UrlUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;

public class CssUrlReferenceHeaderItem
extends CssHeaderItem {
    private final String url;
    private final String media;

    public CssUrlReferenceHeaderItem(String url, String media, String condition) {
        super(condition);
        this.url = url;
        this.media = media;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMedia() {
        return this.media;
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get()), this.getMedia(), this.getCondition());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get()) + "-" + this.media);
    }

    public String toString() {
        return "CSSUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssUrlReferenceHeaderItem) {
            return ((CssUrlReferenceHeaderItem)obj).getUrl().equals(this.getUrl());
        }
        return false;
    }
}

