/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class MarkupUtil {
    public static final boolean isMarkupHtml5Compliant(MarkupContainer container) {
        Args.notNull((Object)container, (String)"container");
        Page page = container.getPage();
        if (page == null) {
            throw new WicketRuntimeException("Component not attached to Page. Component: " + container.toString());
        }
        final boolean[] rtn = new boolean[]{true};
        page.visitChildren(MarkupContainer.class, new IVisitor<MarkupContainer, Void>(){

            public void component(MarkupContainer comp, IVisit<Void> visit) {
                MarkupResourceStream rs;
                Markup associatedMarkup = comp.getAssociatedMarkup();
                if (associatedMarkup != null && !(rs = associatedMarkup.getMarkupResourceStream()).isHtml5()) {
                    rtn[0] = false;
                    visit.stop();
                }
            }
        });
        return rtn[0];
    }
}

