/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.request.ILogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.logger.NoLogData;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public interface IRequestLogger {
    public int getTotalCreatedSessions();

    public int getPeakSessions();

    public List<RequestData> getRequests();

    public SessionData[] getLiveSessions();

    public int getCurrentActiveRequestCount();

    public int getPeakActiveRequestCount();

    public long getRequestsPerMinute();

    public long getAverageRequestTime();

    public void sessionCreated(String var1);

    public void sessionDestroyed(String var1);

    public void requestTime(long var1);

    public void objectRemoved(Object var1);

    public void objectUpdated(Object var1);

    public void objectCreated(Object var1);

    public void logResponseTarget(IRequestHandler var1);

    public void logEventTarget(IRequestHandler var1);

    public void logRequestedUrl(String var1);

    public void performLogging();

    public static interface ISessionLogInfo {
        public Object getSessionInfo();
    }

    public static class RequestData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private long startDate;
        private long timeTaken;
        private final List<String> entries = new ArrayList<String>(5);
        private String requestedUrl;
        private IRequestHandler eventTarget;
        private IRequestHandler responseTarget;
        private String sessionId;
        private long totalSessionSize;
        private Object sessionInfo;
        private int activeRequest;

        public Long getTimeTaken() {
            return this.timeTaken;
        }

        public void setActiveRequest(int activeRequest) {
            this.activeRequest = activeRequest;
        }

        public int getActiveRequest() {
            return this.activeRequest;
        }

        public Object getSessionInfo() {
            return this.sessionInfo;
        }

        public void setSessionInfo(Object sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public void setSessionSize(long sizeInBytes) {
            this.totalSessionSize = sizeInBytes;
        }

        public void setSessionId(String id) {
            this.sessionId = id;
        }

        public Date getStartDate() {
            return new Date(this.startDate);
        }

        public IRequestHandler getEventTarget() {
            return this.eventTarget;
        }

        public Class<? extends IRequestHandler> getEventTargetClass() {
            return this.eventTarget == null ? null : this.eventTarget.getClass();
        }

        public ILogData getEventTargetLog() {
            if (this.eventTarget instanceof ILoggableRequestHandler) {
                return ((ILoggableRequestHandler)this.eventTarget).getLogData();
            }
            return new NoLogData();
        }

        public IRequestHandler getResponseTarget() {
            return this.responseTarget;
        }

        public Class<? extends IRequestHandler> getResponseTargetClass() {
            return this.responseTarget == null ? null : this.responseTarget.getClass();
        }

        public ILogData getResponseTargetLog() {
            if (this.responseTarget instanceof ILoggableRequestHandler) {
                return ((ILoggableRequestHandler)this.responseTarget).getLogData();
            }
            return new NoLogData();
        }

        public String getRequestedUrl() {
            return this.requestedUrl;
        }

        public void setRequestedUrl(String requestedUrl) {
            this.requestedUrl = requestedUrl;
        }

        public void setResponseTarget(IRequestHandler target) {
            this.responseTarget = target;
        }

        public void setEventTarget(IRequestHandler target) {
            this.eventTarget = target;
        }

        public void setTimeTaken(long timeTaken) {
            this.timeTaken = timeTaken;
            this.startDate = System.currentTimeMillis() - timeTaken;
        }

        public void addEntry(String string) {
            this.entries.add(string);
        }

        public String getAlteredObjects() {
            return Strings.join((String)", ", this.entries);
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Long getSessionSize() {
            return this.totalSessionSize;
        }

        public String toString() {
            return "Request[timetaken=" + this.getTimeTaken() + ",sessioninfo=" + this.sessionInfo + ",sessionid=" + this.sessionId + ",sessionsize=" + this.totalSessionSize + ",request=" + this.eventTarget + ",response=" + this.responseTarget + ",alteredobjects=" + this.getAlteredObjects() + ",activerequest=" + this.activeRequest + "]";
        }
    }

    public static class SessionData
    implements IClusterable,
    Comparable<SessionData> {
        private static final long serialVersionUID = 1L;
        private final String sessionId;
        private final long startDate;
        private long lastActive;
        private long numberOfRequests;
        private long totalTimeTaken;
        private long sessionSize;
        private Object sessionInfo;

        public SessionData(String sessionId) {
            this.sessionId = sessionId;
            this.startDate = System.currentTimeMillis();
            this.numberOfRequests = 1L;
        }

        public Date getLastActive() {
            return new Date(this.lastActive);
        }

        public Date getStartDate() {
            return new Date(this.startDate);
        }

        public long getNumberOfRequests() {
            return this.numberOfRequests;
        }

        public long getSessionSize() {
            return this.sessionSize;
        }

        public long getTotalTimeTaken() {
            return this.totalTimeTaken;
        }

        public Object getSessionInfo() {
            return this.sessionInfo;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void addTimeTaken(long time) {
            this.lastActive = System.currentTimeMillis();
            ++this.numberOfRequests;
            this.totalTimeTaken += time;
        }

        public void setSessionInfo(Object sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public void setSessionSize(long size) {
            this.sessionSize = size;
        }

        @Override
        public int compareTo(SessionData sd) {
            return (int)(sd.lastActive - this.lastActive);
        }
    }
}

