/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.iterator;

import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.util.iterator.AbstractHierarchyIteratorWithFilter;
import org.apache.wicket.util.iterator.IteratorFilter;
import org.apache.wicket.util.lang.Args;

public class ComponentHierarchyIterator
extends AbstractHierarchyIteratorWithFilter<Component, Component> {
    public ComponentHierarchyIterator(Component component) {
        super(component);
    }

    public ComponentHierarchyIterator(Component component, Class<?> clazz, boolean visible, boolean enabled) {
        this(component);
        if (clazz != null) {
            this.filterByClass(clazz);
        }
        if (visible) {
            this.filterByVisibility();
        }
        if (enabled) {
            this.filterEnabled();
        }
    }

    public ComponentHierarchyIterator(Component component, Class<?> clazz) {
        this(component, clazz, false, false);
    }

    @Override
    protected Iterator<Component> newIterator(Component node) {
        return ((MarkupContainer)node).iterator();
    }

    @Override
    protected boolean hasChildren(Component elem) {
        if (elem instanceof MarkupContainer) {
            return ((MarkupContainer)elem).size() > 0;
        }
        return false;
    }

    public final ComponentHierarchyIterator filterLeavesOnly() {
        this.getFilters().add(new IteratorFilter<Component>(){

            @Override
            boolean onFilter(Component component) {
                if (component instanceof MarkupContainer) {
                    return ((MarkupContainer)component).size() == 0;
                }
                return true;
            }
        });
        return this;
    }

    public ComponentHierarchyIterator filterByClass(final Class<?> clazz) {
        if (clazz != null) {
            this.getFilters().add(new IteratorFilter<Component>(){

                @Override
                boolean onFilter(Component component) {
                    return clazz.isInstance(component);
                }
            });
        }
        return this;
    }

    public ComponentHierarchyIterator filterByVisibility() {
        IteratorFilter<Component> filter = new IteratorFilter<Component>(){

            @Override
            protected boolean onFilter(Component comp) {
                return comp.isVisibleInHierarchy();
            }
        };
        this.addFilter((IteratorFilter)filter);
        this.addTraverseFilters((IteratorFilter)filter);
        return this;
    }

    public ComponentHierarchyIterator filterEnabled() {
        IteratorFilter<Component> filter = new IteratorFilter<Component>(){

            @Override
            protected boolean onFilter(Component comp) {
                return comp.isEnabledInHierarchy();
            }
        };
        this.addFilter((IteratorFilter)filter);
        this.addTraverseFilters((IteratorFilter)filter);
        return this;
    }

    public ComponentHierarchyIterator filterById(final String match) {
        Args.notEmpty((CharSequence)match, (String)"match");
        this.getFilters().add(new IteratorFilter<Component>(){

            @Override
            protected boolean onFilter(Component comp) {
                return comp.getId().matches(match);
            }
        });
        return this;
    }

    public ComponentHierarchyIterator addFilter(IteratorFilter<Component> filter) {
        super.addFilter(filter);
        return this;
    }

    public ComponentHierarchyIterator addTraverseFilters(IteratorFilter<Component> filter) {
        super.addTraverseFilters(filter);
        return this;
    }
}

