/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.markup.head.AbstractJavaScriptReferenceHeaderItem;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUrlReferenceHeaderItem
extends AbstractJavaScriptReferenceHeaderItem {
    private final String url;
    private final String id;

    public JavaScriptUrlReferenceHeaderItem(String url, String id, boolean defer, String charset, String condition) {
        super(condition, defer, charset);
        this.url = url;
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()), this.getId(), this.isDefer(), this.getCharset(), this.getCondition(), this.isAsync());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get());
        if (Strings.isEmpty((CharSequence)this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaScriptUrlReferenceHeaderItem) {
            return ((JavaScriptUrlReferenceHeaderItem)obj).getUrl().equals(this.getUrl());
        }
        return false;
    }
}

