/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class TagTester {
    private static final Pattern AJAX_COMPONENT_CDATA_OPEN = Pattern.compile("<component.*?><!\\[CDATA\\[");
    private static final Pattern AJAX_COMPONENT_CDATA_CLOSE = Pattern.compile("\\]\\]></component>");
    private final XmlTag openTag;
    private final XmlTag closeTag;
    private final XmlPullParser parser;

    private TagTester(XmlPullParser parser, XmlTag openTag, XmlTag closeTag) {
        this.parser = parser;
        this.openTag = openTag;
        this.closeTag = closeTag;
    }

    public String getName() {
        return this.openTag.getName();
    }

    public boolean hasAttribute(String attribute) {
        boolean hasAttribute = false;
        if (this.getAttribute(attribute) != null) {
            hasAttribute = true;
        }
        return hasAttribute;
    }

    public String getAttribute(String attribute) {
        String value = null;
        IValueMap attributeMap = this.openTag.getAttributes();
        if (attributeMap != null) {
            for (String attr : attributeMap.keySet()) {
                if (!attr.equalsIgnoreCase(attribute)) continue;
                value = attributeMap.getString(attr);
            }
        }
        return value;
    }

    public boolean getAttributeContains(String attribute, String partialValue) {
        String value;
        boolean contains = false;
        if (partialValue != null && (value = this.getAttribute(attribute)) != null && value.contains(partialValue)) {
            contains = true;
        }
        return contains;
    }

    public boolean getAttributeIs(String attribute, String expected) {
        boolean is = false;
        String val = this.getAttribute(attribute);
        if (val == null && expected == null || expected != null && expected.equals(val)) {
            is = true;
        }
        return is;
    }

    public boolean getAttributeEndsWith(String attribute, String expected) {
        String val;
        boolean endsWith = false;
        if (expected != null && (val = this.getAttribute(attribute)) != null && val.endsWith(expected)) {
            endsWith = true;
        }
        return endsWith;
    }

    public boolean hasChildTag(String tagName) {
        boolean hasChild;
        block4: {
            Args.notEmpty((CharSequence)tagName, (String)"tagName");
            hasChild = false;
            if (this.openTag.isOpen()) {
                try {
                    XmlTag tag;
                    int startPos = this.openTag.getPos() + this.openTag.getLength();
                    int endPos = this.closeTag.getPos();
                    String markup = ((Object)this.parser.getInput(startPos, endPos)).toString();
                    if (Strings.isEmpty((CharSequence)markup)) break block4;
                    XmlPullParser p = new XmlPullParser();
                    p.parse(markup);
                    while ((tag = p.nextTag()) != null) {
                        if (!tagName.equalsIgnoreCase(tag.getName())) continue;
                        hasChild = true;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new WicketRuntimeException(e);
                }
            }
        }
        return hasChild;
    }

    public TagTester getChild(String tagName) {
        Args.notNull((Object)tagName, (String)"tagName");
        TagTester childTagTester = null;
        if (this.openTag.isOpen()) {
            int startPos = this.openTag.getPos() + this.openTag.getLength();
            int endPos = this.closeTag.getPos();
            String markup = ((Object)this.parser.getInput(startPos, endPos)).toString();
            childTagTester = TagTester.createTagByAttribute(markup, tagName);
        }
        return childTagTester;
    }

    public TagTester getChild(String attribute, String value) {
        String markup;
        TagTester childTag = null;
        if (this.openTag.isOpen() && !Strings.isEmpty((CharSequence)(markup = this.getMarkup()))) {
            childTag = TagTester.createTagByAttribute(markup, attribute, value);
        }
        return childTag;
    }

    public String getMarkup() {
        int openPos = this.openTag.getPos();
        int closePos = this.closeTag.getPos() + this.closeTag.getLength();
        return ((Object)this.parser.getInput(openPos, closePos)).toString();
    }

    public String getValue() {
        int openPos = this.openTag.getPos() + this.openTag.getLength();
        int closePos = this.closeTag.getPos();
        return ((Object)this.parser.getInput(openPos, closePos)).toString();
    }

    public static TagTester createTagByAttribute(String markup, String tagName) {
        TagTester tester = null;
        if (!Strings.isEmpty((CharSequence)markup) && !Strings.isEmpty((CharSequence)tagName)) {
            try {
                XmlTag elm;
                markup = AJAX_COMPONENT_CDATA_OPEN.matcher(markup).replaceAll("<component>");
                markup = AJAX_COMPONENT_CDATA_CLOSE.matcher(markup).replaceAll("</component>");
                XmlPullParser parser = new XmlPullParser();
                parser.parse(markup);
                XmlTag openTag = null;
                XmlTag closeTag = null;
                int level = 0;
                while ((elm = parser.nextTag()) != null && closeTag == null) {
                    XmlTag xmlTag = elm;
                    String xmlTagName = xmlTag.getName();
                    if (openTag == null && xmlTagName.equalsIgnoreCase(tagName)) {
                        if (xmlTag.isOpen()) {
                            openTag = xmlTag;
                            continue;
                        }
                        if (!xmlTag.isOpenClose()) continue;
                        openTag = xmlTag;
                        closeTag = xmlTag;
                        continue;
                    }
                    if (openTag == null) continue;
                    String openTagName = openTag.getName();
                    if (xmlTag.isOpen() && xmlTagName.equals(openTagName)) {
                        ++level;
                    }
                    if (!xmlTag.isClose() || !xmlTagName.equals(openTagName)) continue;
                    if (level == 0) {
                        closeTag = xmlTag;
                        closeTag.setOpenTag(openTag);
                        continue;
                    }
                    --level;
                }
                if (openTag != null && closeTag != null) {
                    tester = new TagTester(parser, openTag, closeTag);
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }
        return tester;
    }

    public static TagTester createTagByAttribute(String markup, String attribute, String value) {
        TagTester tester = null;
        if (!(Strings.isEmpty((CharSequence)markup) || Strings.isEmpty((CharSequence)attribute) || Strings.isEmpty((CharSequence)value))) {
            try {
                XmlTag elm;
                markup = AJAX_COMPONENT_CDATA_OPEN.matcher(markup).replaceAll("<component>");
                markup = AJAX_COMPONENT_CDATA_CLOSE.matcher(markup).replaceAll("</component>");
                XmlPullParser parser = new XmlPullParser();
                parser.parse(markup);
                XmlTag openTag = null;
                XmlTag closeTag = null;
                int level = 0;
                while ((elm = parser.nextTag()) != null && closeTag == null) {
                    XmlTag xmlTag = elm;
                    if (openTag == null) {
                        IValueMap attributeMap = xmlTag.getAttributes();
                        for (Map.Entry entry : attributeMap.entrySet()) {
                            String attr = (String)entry.getKey();
                            if (!attr.equals(attribute) || !value.equals(entry.getValue())) continue;
                            if (xmlTag.isOpen()) {
                                openTag = xmlTag;
                                continue;
                            }
                            if (!xmlTag.isOpenClose()) continue;
                            openTag = xmlTag;
                            closeTag = xmlTag;
                        }
                        continue;
                    }
                    if (xmlTag.isOpen() && xmlTag.getName().equals(openTag.getName())) {
                        ++level;
                    }
                    if (!xmlTag.isClose() || !xmlTag.getName().equals(openTag.getName())) continue;
                    if (level == 0) {
                        closeTag = xmlTag;
                        closeTag.setOpenTag(openTag);
                        continue;
                    }
                    --level;
                }
                if (openTag != null && closeTag != null) {
                    tester = new TagTester(parser, openTag, closeTag);
                } else if (openTag != null) {
                    tester = new TagTester(parser, openTag, openTag);
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }
        return tester;
    }

    public static TagTester createTagsByAttribute(String markup, String attribute, String value) {
        List<TagTester> tester = TagTester.createTagsByAttribute(markup, attribute, value, true);
        if (tester == null || tester.size() == 0) {
            return null;
        }
        return tester.get(0);
    }

    public static List<TagTester> createTagsByAttribute(String markup, String attribute, String value, boolean stopAfterFirst) {
        ArrayList<TagTester> testers = new ArrayList<TagTester>();
        if (!(Strings.isEmpty((CharSequence)markup) || Strings.isEmpty((CharSequence)attribute) || Strings.isEmpty((CharSequence)value))) {
            try {
                XmlTag elm;
                markup = AJAX_COMPONENT_CDATA_OPEN.matcher(markup).replaceAll("<component>");
                markup = AJAX_COMPONENT_CDATA_CLOSE.matcher(markup).replaceAll("</component>");
                XmlPullParser parser = new XmlPullParser();
                parser.parse(markup);
                XmlTag openTag = null;
                XmlTag closeTag = null;
                int level = 0;
                while ((elm = parser.nextTag()) != null) {
                    TagTester tester;
                    XmlTag xmlTag = elm;
                    if (openTag == null) {
                        IValueMap attributeMap = xmlTag.getAttributes();
                        for (Map.Entry entry : attributeMap.entrySet()) {
                            if (!((String)entry.getKey()).equals(attribute) || !value.equals(entry.getValue())) continue;
                            if (xmlTag.isOpen()) {
                                openTag = xmlTag;
                                continue;
                            }
                            if (!xmlTag.isOpenClose()) continue;
                            openTag = xmlTag;
                            closeTag = xmlTag;
                        }
                    } else {
                        if (xmlTag.isOpen() && xmlTag.getName().equals(openTag.getName())) {
                            ++level;
                        }
                        if (xmlTag.isClose() && xmlTag.getName().equals(openTag.getName())) {
                            if (level == 0) {
                                closeTag = xmlTag;
                                closeTag.setOpenTag(openTag);
                            } else {
                                --level;
                            }
                        }
                    }
                    if (openTag != null && closeTag != null && level == 0) {
                        tester = new TagTester(parser, openTag, closeTag);
                        testers.add(tester);
                        openTag = null;
                        closeTag = null;
                    } else if (openTag != null) {
                        tester = new TagTester(parser, openTag, openTag);
                        testers.add(tester);
                        openTag = null;
                        closeTag = null;
                    }
                    if (!stopAfterFirst || closeTag == null) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }
        return testers;
    }
}

