/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.list.AbstractItem;
import org.apache.wicket.markup.html.panel.AbstractMarkupSourcingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMarkupSourcingStrategy
extends AbstractMarkupSourcingStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultMarkupSourcingStrategy.class);
    private static DefaultMarkupSourcingStrategy instance = new DefaultMarkupSourcingStrategy();

    public static final DefaultMarkupSourcingStrategy get() {
        return instance;
    }

    private DefaultMarkupSourcingStrategy() {
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
    }

    @Override
    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        component.onComponentTagBody(markupStream, openTag);
    }

    @Override
    public IMarkupFragment getMarkup(MarkupContainer container, Component child) {
        IMarkupFragment markup = container.getMarkup();
        if (markup == null) {
            return null;
        }
        if (child == null) {
            return markup;
        }
        if ((markup = markup.find(child.getId())) != null) {
            return markup;
        }
        markup = this.searchMarkupInTransparentResolvers(container, child);
        if (markup != null) {
            return markup;
        }
        if (Character.isDigit(child.getId().charAt(0))) {
            String id = child.getId();
            boolean miss = false;
            for (int i = 1; i < id.length(); ++i) {
                if (Character.isDigit(id.charAt(i))) continue;
                miss = true;
                break;
            }
            if (!miss) {
                markup = container.getMarkup();
                if (!(child instanceof AbstractItem) && log.isWarnEnabled()) {
                    log.warn("1.4 to 1.5 migration issue: the childs wicket-id contains decimals only. By convention that is only the case for children (Items) of Loop, ListView, Tree etc.. To avoid the warning, the childs container should implement:\n@Override public IMarkupFragment getMarkup(Component child) {\n// The childs markup is always equal to the parents markup.\nreturn getMarkup(); }\nChild: " + child.toString() + "\nContainer: " + container.toString());
                }
            }
        }
        return markup;
    }
}

