/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(PropertyResolver.class);
    private static final int RETURN_NULL = 0;
    private static final int CREATE_NEW_VALUE = 1;
    private static final int RESOLVE_CLASS = 2;
    private static final ConcurrentHashMap<Object, IClassCache> applicationToClassesToGetAndSetters = Generics.newConcurrentHashMap((int)2);
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";

    public static final Object getValue(String expression, Object object) {
        if (expression == null || expression.equals("") || object == null) {
            return object;
        }
        ObjectAndGetSetter getter = PropertyResolver.getObjectAndGetSetter(expression, object, 0);
        if (getter == null) {
            return null;
        }
        return getter.getValue();
    }

    public static final void setValue(String expression, Object object, Object value, PropertyResolverConverter converter) {
        if (Strings.isEmpty((CharSequence)expression)) {
            throw new WicketRuntimeException("Empty expression setting value: " + value + " on object: " + object);
        }
        if (object == null) {
            throw new WicketRuntimeException("Attempted to set property value on a null object. Property expression: " + expression + " Value: " + value);
        }
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 1);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for setting value: " + value + " on: " + object);
        }
        setter.setValue(value, converter == null ? new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale()) : converter);
    }

    public static final Class<?> getPropertyClass(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getTargetClass();
    }

    public static <T> Class<T> getPropertyClass(String expression, Class<?> clz) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, null, 2, clz);
        if (setter == null) {
            throw new WicketRuntimeException("No Class returned for expression: " + expression + " for getting the target class of: " + clz);
        }
        return setter.getTargetClass();
    }

    public static final Field getPropertyField(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getField();
    }

    public static final Method getPropertyGetter(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getGetter();
    }

    public static final Method getPropertySetter(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getSetter();
    }

    private static ObjectAndGetSetter getObjectAndGetSetter(String expression, Object object, int tryToCreateNull) {
        return PropertyResolver.getObjectAndGetSetter(expression, object, tryToCreateNull, object.getClass());
    }

    private static ObjectAndGetSetter getObjectAndGetSetter(String expression, Object object, int tryToCreateNull, Class<?> clz) {
        IGetAndSet getAndSetter;
        String expressionBracketsSeperated = ((Object)Strings.replaceAll((CharSequence)expression, (CharSequence)"[", (CharSequence)".[")).toString();
        int index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        while (index == 0 && expressionBracketsSeperated.startsWith(".")) {
            expressionBracketsSeperated = expressionBracketsSeperated.substring(1);
            index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        }
        int lastIndex = 0;
        Object value = object;
        String exp = expressionBracketsSeperated;
        while (index != -1) {
            exp = expressionBracketsSeperated.substring(lastIndex, index);
            if (exp.length() == 0) {
                exp = expressionBracketsSeperated.substring(index + 1);
                break;
            }
            getAndSetter = null;
            try {
                getAndSetter = PropertyResolver.getGetAndSetter(exp, clz);
            }
            catch (WicketRuntimeException ex) {
                index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, index + 1);
                if (index == -1) {
                    exp = expressionBracketsSeperated.substring(lastIndex);
                    break;
                }
                String indexExpression = expressionBracketsSeperated.substring(lastIndex, index);
                getAndSetter = PropertyResolver.getGetAndSetter(indexExpression, clz);
            }
            Object newValue = null;
            if (value != null) {
                newValue = getAndSetter.getValue(value);
            }
            if (newValue == null) {
                if (tryToCreateNull == 1) {
                    newValue = getAndSetter.newValue(value);
                    if (newValue == null) {
                        return null;
                    }
                } else if (tryToCreateNull == 2) {
                    clz = getAndSetter.getTargetClass();
                } else {
                    return null;
                }
            }
            if ((value = newValue) != null) {
                clz = value.getClass();
            }
            if ((index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, lastIndex = index + 1)) != -1) continue;
            exp = expressionBracketsSeperated.substring(lastIndex);
            break;
        }
        getAndSetter = PropertyResolver.getGetAndSetter(exp, clz);
        return new ObjectAndGetSetter(getAndSetter, value);
    }

    private static int getNextDotIndex(String expression, int start) {
        boolean insideBracket = false;
        for (int i = start; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '.' && !insideBracket) {
                return i;
            }
            if (ch == '[') {
                insideBracket = true;
                continue;
            }
            if (ch != ']') continue;
            insideBracket = false;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final IGetAndSet getGetAndSetter(String exp, Class<?> clz) {
        IGetAndSet getAndSetter;
        IClassCache classesToGetAndSetters = PropertyResolver.getClassesToGetAndSetters();
        Map<String, IGetAndSet> getAndSetters = classesToGetAndSetters.get(clz);
        if (getAndSetters == null) {
            getAndSetters = new ConcurrentHashMap<String, IGetAndSet>(8);
            classesToGetAndSetters.put(clz, getAndSetters);
        }
        if ((getAndSetter = getAndSetters.get(exp)) != null) return getAndSetter;
        Method method = null;
        Field field = null;
        if (exp.startsWith("[")) {
            exp = exp.substring(1, exp.length() - 1);
        } else {
            method = exp.endsWith("()") ? PropertyResolver.findMethod(clz, exp) : PropertyResolver.findGetter(clz, exp);
        }
        if (method == null) {
            if (List.class.isAssignableFrom(clz)) {
                try {
                    int index = Integer.parseInt(exp);
                    getAndSetter = new ListGetSet(index);
                }
                catch (NumberFormatException ex) {
                    method = PropertyResolver.findMethod(clz, exp);
                    if (method != null) {
                        getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                    }
                    field = PropertyResolver.findField(clz, exp);
                    if (field == null) throw new WicketRuntimeException("The expression '" + exp + "' is neither an index nor is it a method or field for the list " + clz);
                    getAndSetter = new FieldGetAndSetter(field);
                }
            } else if (Map.class.isAssignableFrom(clz)) {
                getAndSetter = new MapGetSet(exp);
            } else if (clz.isArray()) {
                try {
                    int index = Integer.parseInt(exp);
                    getAndSetter = new ArrayGetSet(clz.getComponentType(), index);
                }
                catch (NumberFormatException ex) {
                    if (!exp.equals("length") && !exp.equals("size")) throw new WicketRuntimeException("Can't parse the expression '" + exp + "' as an index for an array lookup");
                    getAndSetter = new ArrayLengthGetSet();
                }
            } else {
                field = PropertyResolver.findField(clz, exp);
                if (field == null) {
                    method = PropertyResolver.findMethod(clz, exp);
                    if (method == null) {
                        int index = exp.indexOf(46);
                        if (index == -1) throw new WicketRuntimeException("No get method defined for class: " + clz + " expression: " + exp);
                        String propertyName = exp.substring(0, index);
                        String propertyIndex = exp.substring(index + 1);
                        try {
                            int parsedIndex = Integer.parseInt(propertyIndex);
                            String name = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                            method = clz.getMethod(GET + name, Integer.TYPE);
                            getAndSetter = new ArrayPropertyGetSet(method, parsedIndex);
                        }
                        catch (Exception e) {
                            throw new WicketRuntimeException("No get method defined for class: " + clz + " expression: " + propertyName);
                        }
                    } else {
                        getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                    }
                } else {
                    getAndSetter = new FieldGetAndSetter(field);
                }
            }
        } else {
            field = PropertyResolver.findField(clz, exp);
            getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), field);
        }
        getAndSetters.put(exp, getAndSetter);
        return getAndSetter;
    }

    private static Field findField(Class<?> clz, String expression) {
        Field field = null;
        try {
            field = clz.getField(expression);
        }
        catch (Exception e) {
            for (Class<?> tmp = clz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
                Field[] fields;
                for (Field aField : fields = tmp.getDeclaredFields()) {
                    if (!aField.getName().equals(expression)) continue;
                    aField.setAccessible(true);
                    return aField;
                }
            }
            log.debug("Cannot find field " + clz + "." + expression);
        }
        return field;
    }

    private static final Method findGetter(Class<?> clz, String expression) {
        String name = Character.toUpperCase(expression.charAt(0)) + expression.substring(1);
        Method method = null;
        try {
            method = clz.getMethod(GET + name, null);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clz.getMethod(IS + name, null);
            }
            catch (Exception e) {
                log.debug("Cannot find getter " + clz + "." + expression);
            }
        }
        return method;
    }

    private static final Method findMethod(Class<?> clz, String expression) {
        if (expression.endsWith("()")) {
            expression = expression.substring(0, expression.length() - 2);
        }
        Method method = null;
        try {
            method = clz.getMethod(expression, null);
        }
        catch (Exception e) {
            log.debug("Cannot find method " + clz + "." + expression);
        }
        return method;
    }

    private PropertyResolver() {
    }

    private static IClassCache getClassesToGetAndSetters() {
        IClassCache tmpResult;
        Object key = Application.exists() ? Application.get() : PropertyResolver.class;
        IClassCache result = applicationToClassesToGetAndSetters.get(key);
        if (result == null && (tmpResult = applicationToClassesToGetAndSetters.putIfAbsent(key, result = new DefaultClassCache())) != null) {
            result = tmpResult;
        }
        return result;
    }

    public static void destroy(Application application) {
        applicationToClassesToGetAndSetters.remove(application);
    }

    public static void setClassCache(Application application, IClassCache classCache) {
        if (application != null) {
            applicationToClassesToGetAndSetters.put(application, classCache);
        } else {
            applicationToClassesToGetAndSetters.put(PropertyResolver.class, classCache);
        }
    }

    private static class DefaultClassCache
    implements IClassCache {
        private final ConcurrentHashMap<Class<?>, Map<String, IGetAndSet>> map = Generics.newConcurrentHashMap((int)16);

        private DefaultClassCache() {
        }

        @Override
        public Map<String, IGetAndSet> get(Class<?> clz) {
            return this.map.get(clz);
        }

        @Override
        public void put(Class<?> clz, Map<String, IGetAndSet> values) {
            this.map.put(clz, values);
        }
    }

    public static interface IClassCache {
        public void put(Class<?> var1, Map<String, IGetAndSet> var2);

        public Map<String, IGetAndSet> get(Class<?> var1);
    }

    private static class FieldGetAndSetter
    extends AbstractGetAndSet {
        private final Field field;

        public FieldGetAndSetter(Field field) {
            this.field = field;
            this.field.setAccessible(true);
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.field.get(object);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error getting field value of field " + this.field + " from object " + object, ex);
            }
        }

        @Override
        public Object newValue(Object object) {
            Class<?> clz = this.field.getType();
            Object value = null;
            try {
                value = clz.newInstance();
                this.field.set(object, value);
            }
            catch (Exception e) {
                log.warn("Cannot set field " + this.field + " to " + value, (Throwable)e);
            }
            return value;
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            value = converter.convert(value, this.field.getType());
            try {
                this.field.set(object, value);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error setting field value of field " + this.field + " on object " + object + ", value " + value, ex);
            }
        }

        @Override
        public Class<?> getTargetClass() {
            return this.field.getType();
        }

        @Override
        public Field getField() {
            return this.field;
        }
    }

    private static final class MethodGetAndSet
    extends AbstractGetAndSet {
        private final Method getMethod;
        private final Method setMethod;
        private final Field field;

        MethodGetAndSet(Method getMethod, Method setMethod, Field field) {
            this.getMethod = getMethod;
            this.getMethod.setAccessible(true);
            this.field = field;
            this.setMethod = setMethod;
        }

        @Override
        public final Object getValue(Object object) {
            Object ret = null;
            try {
                ret = this.getMethod.invoke(object, (Object[])null);
            }
            catch (InvocationTargetException ex) {
                throw new WicketRuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex);
            }
            return ret;
        }

        @Override
        public final void setValue(Object object, Object value, PropertyResolverConverter converter) {
            Class<?> type = null;
            if (this.setMethod != null) {
                type = this.getMethod.getReturnType();
            } else if (this.field != null) {
                type = this.field.getType();
            }
            Object converted = null;
            if (type != null && (converted = converter.convert(value, type)) == null) {
                if (value != null) {
                    throw new ConversionException("Method [" + this.getMethod + "]. Can't convert value: " + value + " to class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                }
                if (this.getMethod.getReturnType().isPrimitive()) {
                    throw new ConversionException("Method [" + this.getMethod + "]. Can't convert null value to a primitive class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                }
            }
            if (this.setMethod != null) {
                try {
                    this.setMethod.invoke(object, converted);
                }
                catch (InvocationTargetException ex) {
                    throw new WicketRuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex.getCause());
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex);
                }
            } else if (this.field != null) {
                try {
                    this.field.set(object, converted);
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error setting field: " + this.field + " on object: " + object, ex);
                }
            } else {
                throw new WicketRuntimeException("no set method defined for value: " + value + " on object: " + object + " while respective getMethod being " + this.getMethod.getName());
            }
        }

        private static final Method findSetter(Method getMethod, Class<?> clz) {
            String name = getMethod.getName();
            name = name.startsWith(PropertyResolver.GET) ? PropertyResolver.SET + name.substring(3) : PropertyResolver.SET + name.substring(2);
            try {
                Method method = clz.getMethod(name, getMethod.getReturnType());
                if (method != null) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                Method[] methods;
                for (Method method : methods = clz.getMethods()) {
                    Class<?>[] parameterTypes;
                    if (!method.getName().equals(name) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(getMethod.getReturnType())) continue;
                    return method;
                }
                log.debug("Cannot find setter corresponding to " + getMethod);
            }
            catch (Exception e) {
                log.debug("Cannot find setter corresponding to " + getMethod);
            }
            return null;
        }

        @Override
        public Object newValue(Object object) {
            if (this.setMethod == null) {
                log.warn("Null setMethod");
                return null;
            }
            Class<?> clz = this.getMethod.getReturnType();
            Object value = null;
            try {
                value = clz.newInstance();
                this.setMethod.invoke(object, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value, (Throwable)e);
            }
            return value;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.getMethod.getReturnType();
        }

        @Override
        public Method getGetter() {
            return this.getMethod;
        }

        @Override
        public Method getSetter() {
            return this.setMethod;
        }

        @Override
        public Field getField() {
            return this.field;
        }
    }

    private static final class ArrayPropertyGetSet
    extends AbstractGetAndSet {
        private final Integer index;
        private final Method getMethod;
        private Method setMethod;

        ArrayPropertyGetSet(Method method, int index) {
            this.index = index;
            this.getMethod = method;
            this.getMethod.setAccessible(true);
        }

        private static final Method findSetter(Method getMethod, Class<?> clz) {
            String name = getMethod.getName();
            name = PropertyResolver.SET + name.substring(3);
            try {
                return clz.getMethod(name, Integer.TYPE, getMethod.getReturnType());
            }
            catch (Exception e) {
                log.debug("Can't find setter method corresponding to " + getMethod);
                return null;
            }
        }

        @Override
        public Object getValue(Object object) {
            Object ret = null;
            try {
                ret = this.getMethod.invoke(object, this.index);
            }
            catch (InvocationTargetException ex) {
                throw new WicketRuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex);
            }
            return ret;
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            if (this.setMethod == null) {
                this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
            }
            if (this.setMethod != null) {
                this.setMethod.setAccessible(true);
                Object converted = converter.convert(value, this.getMethod.getReturnType());
                if (converted == null && value != null) {
                    throw new ConversionException("Can't convert value: " + value + " to class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                }
                try {
                    this.setMethod.invoke(object, this.index, converted);
                }
                catch (InvocationTargetException ex) {
                    throw new WicketRuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex.getCause());
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex);
                }
            } else {
                throw new WicketRuntimeException("No set method defined for value: " + value + " on object: " + object);
            }
        }

        @Override
        public Class<?> getTargetClass() {
            return this.getMethod.getReturnType();
        }

        @Override
        public Object newValue(Object object) {
            if (this.setMethod == null) {
                this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
            }
            if (this.setMethod == null) {
                log.warn("Null setMethod");
                return null;
            }
            Class<?> clz = this.getMethod.getReturnType();
            Object value = null;
            try {
                value = clz.newInstance();
                this.setMethod.invoke(object, this.index, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value + " at index " + this.index, (Throwable)e);
            }
            return value;
        }
    }

    private static final class ArrayLengthGetSet
    extends AbstractGetAndSet {
        ArrayLengthGetSet() {
        }

        @Override
        public Object getValue(Object object) {
            return Array.getLength(object);
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            throw new WicketRuntimeException("You can't set the length on an array:" + object);
        }

        @Override
        public Object newValue(Object object) {
            throw new WicketRuntimeException("Can't get a new value from a length of an array: " + object);
        }

        @Override
        public Class<?> getTargetClass() {
            return Integer.TYPE;
        }
    }

    private static final class ArrayGetSet
    extends AbstractGetAndSet {
        private final int index;
        private final Class<?> clzComponentType;

        ArrayGetSet(Class<?> clzComponentType, int index) {
            this.clzComponentType = clzComponentType;
            this.index = index;
        }

        @Override
        public Object getValue(Object object) {
            if (Array.getLength(object) > this.index) {
                return Array.get(object, this.index);
            }
            return null;
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            value = converter.convert(value, this.clzComponentType);
            Array.set(object, this.index, value);
        }

        @Override
        public Object newValue(Object object) {
            Object value = null;
            try {
                value = this.clzComponentType.newInstance();
                Array.set(object, this.index, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value + " at index " + this.index + " for array holding elements of class " + this.clzComponentType, (Throwable)e);
            }
            return value;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.clzComponentType;
        }
    }

    private static final class ListGetSet
    extends AbstractGetAndSet {
        private final int index;

        ListGetSet(int index) {
            this.index = index;
        }

        @Override
        public Object getValue(Object object) {
            if (((List)object).size() <= this.index) {
                return null;
            }
            return ((List)object).get(this.index);
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            List lst = (List)object;
            if (lst.size() > this.index) {
                lst.set(this.index, value);
            } else if (lst.size() == this.index) {
                lst.add(value);
            } else {
                while (lst.size() < this.index) {
                    lst.add(null);
                }
                lst.add(value);
            }
        }

        @Override
        public Object newValue(Object object) {
            return null;
        }
    }

    private static final class MapGetSet
    extends AbstractGetAndSet {
        private final String key;

        MapGetSet(String key) {
            this.key = key;
        }

        @Override
        public Object getValue(Object object) {
            return ((Map)object).get(this.key);
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            ((Map)object).put(this.key, value);
        }

        @Override
        public Object newValue(Object object) {
            return null;
        }
    }

    private static abstract class AbstractGetAndSet
    implements IGetAndSet {
        private AbstractGetAndSet() {
        }

        @Override
        public Field getField() {
            return null;
        }

        @Override
        public Method getGetter() {
            return null;
        }

        @Override
        public Method getSetter() {
            return null;
        }

        @Override
        public Class<?> getTargetClass() {
            return null;
        }
    }

    public static interface IGetAndSet {
        public Object getValue(Object var1);

        public Class<?> getTargetClass();

        public Object newValue(Object var1);

        public void setValue(Object var1, Object var2, PropertyResolverConverter var3);

        public Field getField();

        public Method getGetter();

        public Method getSetter();
    }

    private static final class ObjectAndGetSetter {
        private final IGetAndSet getAndSetter;
        private final Object value;

        public ObjectAndGetSetter(IGetAndSet getAndSetter, Object value) {
            this.getAndSetter = getAndSetter;
            this.value = value;
        }

        public void setValue(Object value, PropertyResolverConverter converter) {
            this.getAndSetter.setValue(this.value, value, converter);
        }

        public Object getValue() {
            return this.getAndSetter.getValue(this.value);
        }

        public Class<?> getTargetClass() {
            return this.getAndSetter.getTargetClass();
        }

        public Field getField() {
            return this.getAndSetter.getField();
        }

        public Method getGetter() {
            return this.getAndSetter.getGetter();
        }

        public Method getSetter() {
            return this.getAndSetter.getSetter();
        }
    }
}

