/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import java.util.ArrayList;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderItemWrapper;
import org.apache.wicket.request.Response;

public class FilteredHeaderItem
extends HeaderItem
implements IHeaderItemWrapper {
    private HeaderItem wrapped;
    private String filterName;

    public FilteredHeaderItem(HeaderItem wrapped, String filterName) {
        this.wrapped = wrapped;
        this.filterName = filterName;
    }

    @Override
    public HeaderItem getWrapped() {
        return this.wrapped;
    }

    @Override
    public FilteredHeaderItem wrap(HeaderItem item) {
        return new FilteredHeaderItem(item, this.getFilterName());
    }

    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return this.getWrapped().getRenderTokens();
    }

    @Override
    public void render(Response response) {
        this.getWrapped().render(response);
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        ArrayList<FilteredHeaderItem> ret = new ArrayList<FilteredHeaderItem>();
        for (HeaderItem headerItem : this.getWrapped().getDependencies()) {
            ret.add(this.wrap(headerItem));
        }
        return ret;
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        return this.getWrapped().getProvidedResources();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredHeaderItem that = (FilteredHeaderItem)o;
        if (this.wrapped != null ? !this.wrapped.equals(that.wrapped) : that.wrapped != null) {
            return false;
        }
        return this.filterName != null ? this.filterName.equals(that.filterName) : that.filterName == null;
    }

    public int hashCode() {
        int result = this.wrapped != null ? this.wrapped.hashCode() : 0;
        result = 31 * result + (this.filterName != null ? this.filterName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FilteredHeaderItem(" + this.getWrapped() + ", " + this.getFilterName() + ")";
    }
}

