/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html;

import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;

public abstract class AjaxFallbackLink<T>
extends Link<T>
implements IAjaxLink {
    private static final long serialVersionUID = 1L;

    public AjaxFallbackLink(String id) {
        this(id, (IModel<T>)null);
    }

    public AjaxFallbackLink(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxEventBehavior("click"));
    }

    protected AjaxEventBehavior newAjaxEventBehavior(String event) {
        return new AjaxEventBehavior(event){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                AjaxFallbackLink.this.onClick(target);
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setPreventDefault(true);
                AjaxFallbackLink.this.updateAjaxAttributes(attributes);
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    public final void onClick() {
        this.onClick(null);
    }

    @Override
    public abstract void onClick(AjaxRequestTarget var1);

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("onclick");
        String tagName = tag.getName();
        if (this.isEnabledInHierarchy() && !"a".equalsIgnoreCase(tagName) && !"area".equalsIgnoreCase(tagName) && !"link".equalsIgnoreCase(tagName)) {
            String msg = String.format("%s must be used only with <a>, <area> or <link> markup elements. The fallback functionality doesn't work for other markup elements. Component path: %s, markup element: <%s>.", AjaxFallbackLink.class.getSimpleName(), this.getClassRelativePath(), tagName);
            this.findMarkupStream().throwMarkupException(msg);
        }
    }
}

