/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.lang.reflect.Modifier;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.PackageName;

public class PackageMapper
extends AbstractBookmarkableMapper {
    private final PackageName packageName;

    public PackageMapper(String mountPath, PackageName packageName) {
        this(mountPath, packageName, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public PackageMapper(String mountPath, PackageName packageName, IPageParametersEncoder pageParametersEncoder) {
        super(mountPath, pageParametersEncoder);
        Args.notNull((Object)packageName, (String)"packageName");
        this.packageName = packageName;
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Class<? extends IRequestablePage> pageClass = info.getPageClass();
        PackageName pageClassPackageName = PackageName.forClass(pageClass);
        if (pageClassPackageName.equals((Object)this.packageName)) {
            String fullyQualifiedClassName;
            Url url = new Url();
            for (String s : this.mountSegments) {
                url.getSegments().add(s);
            }
            String packageRelativeClassName = fullyQualifiedClassName = pageClass.getName();
            int packageNameLength = this.packageName.getName().length();
            if (packageNameLength > 0) {
                packageRelativeClassName = fullyQualifiedClassName.substring(packageNameLength + 1);
            }
            packageRelativeClassName = this.transformForUrl(packageRelativeClassName);
            url.getSegments().add(packageRelativeClassName);
            this.encodePageComponentInfo(url, info.getPageComponentInfo());
            PageParameters copy = new PageParameters(info.getPageParameters());
            if (!this.setPlaceholders(copy, url)) {
                return null;
            }
            return this.encodePageParameters(url, copy, this.pageParametersEncoder);
        }
        return null;
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        Url url = request.getUrl();
        if (this.urlStartsWithMountedSegments(url)) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            String name = (String)url.getSegments().get(this.mountSegments.length);
            String className = this.cleanClassName(name);
            if (!this.isValidClassName(className)) {
                return null;
            }
            className = this.transformFromUrl(className);
            String fullyQualifiedClassName = this.packageName.getName() + '.' + className;
            Class<? extends IRequestablePage> pageClass = this.getPageClass(fullyQualifiedClassName);
            if (pageClass != null && !Modifier.isAbstract(pageClass.getModifiers()) && IRequestablePage.class.isAssignableFrom(pageClass)) {
                Url urlWithoutPageSegment = new Url(url);
                urlWithoutPageSegment.getSegments().remove(this.mountSegments.length);
                Request requestWithoutPageSegment = request.cloneWithUrl(urlWithoutPageSegment);
                PageParameters pageParameters = this.extractPageParameters(requestWithoutPageSegment, urlWithoutPageSegment);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    private boolean isValidClassName(String className) {
        if (className == null) {
            return false;
        }
        return !className.startsWith(".");
    }

    protected String transformFromUrl(String classNameAlias) {
        return classNameAlias;
    }

    protected String transformForUrl(String className) {
        return className;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return false;
    }

    @Override
    protected boolean checkPageClass(Class<? extends IRequestablePage> pageClass) {
        PackageName pageClassPackageName = PackageName.forClass(pageClass);
        return this.packageName.equals((Object)pageClassPackageName);
    }
}

