/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class JavaScriptContentHeaderItem
extends JavaScriptHeaderItem {
    private final CharSequence javaScript;

    public JavaScriptContentHeaderItem(CharSequence javaScript, String id, String condition) {
        super(condition);
        this.javaScript = javaScript;
        this.setId(id);
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)this.getCondition());
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)this.getCondition());
            response.write((CharSequence)"]>");
        }
        JavaScriptUtils.writeJavaScript(response, this.getJavaScript(), this.getId());
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty((CharSequence)this.getId())) {
            return Collections.singletonList(this.getJavaScript());
        }
        return Arrays.asList(this.getId(), this.getJavaScript());
    }

    public String toString() {
        return "JavaScriptHeaderItem(" + this.getJavaScript() + ")";
    }

    public int hashCode() {
        return this.getJavaScript().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaScriptContentHeaderItem) {
            return ((JavaScriptContentHeaderItem)obj).getJavaScript().equals(this.getJavaScript());
        }
        return false;
    }
}

