/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.JavaScriptLibrarySettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnEventHeaderItem
extends HeaderItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnEventHeaderItem.class);
    private final String target;
    private final String event;
    private final CharSequence javaScript;

    public static OnEventHeaderItem forScript(String target, String event, CharSequence javaScript) {
        return new OnEventHeaderItem(target, event, javaScript);
    }

    public OnEventHeaderItem(String target, String event) {
        this(target, event, null);
    }

    public OnEventHeaderItem(String target, String event, CharSequence javaScript) {
        this.target = (String)Args.notEmpty((CharSequence)target, (String)"target");
        Args.notEmpty((CharSequence)event, (String)"event");
        event = event.toLowerCase(Locale.ENGLISH);
        if (event.startsWith("on")) {
            String shortName = event.substring(2);
            LOGGER.warn("Since version 6.0.0 Wicket uses JavaScript event registration so there is no need of the leading 'on' in the event name '{}'. Please use just '{}'. Wicket 8.x won't manipulate the provided event names so the leading 'on' may break your application.", (Object)event, (Object)shortName);
            event = shortName;
        }
        this.event = event;
        this.javaScript = javaScript;
    }

    public String getTarget() {
        return this.target;
    }

    public String getEvent() {
        return this.event;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        if (!Strings.isEmpty((CharSequence)this.getJavaScript())) {
            JavaScriptUtils.writeJavaScript(response, this.getCompleteJavaScript());
        }
    }

    public CharSequence getCompleteJavaScript() {
        StringBuilder result = new StringBuilder();
        result.append("Wicket.Event.add(").append(this.getTarget()).append(", \"").append(this.getEvent()).append("\", function(event) { ").append(this.getJavaScript()).append(";});");
        return result;
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-event-" + this.getTarget() + "-" + this.getEvent() + "-" + this.getJavaScript());
    }

    public String toString() {
        return "OnEventHeaderItem(" + this.getTarget() + ", '" + this.getEvent() + "', '" + this.getJavaScript() + "')";
    }

    public int hashCode() {
        return this.getTarget().hashCode() ^ this.getEvent().hashCode() ^ this.getJavaScript().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnEventHeaderItem) {
            OnEventHeaderItem other = (OnEventHeaderItem)obj;
            return other.getTarget().equals(this.getTarget()) && other.getEvent().equals(this.getEvent()) && other.getJavaScript().equals(this.getJavaScript());
        }
        return false;
    }

    @Override
    public List<HeaderItem> getDependencies() {
        JavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketEventReference = ajaxSettings.getWicketEventReference();
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.add(JavaScriptHeaderItem.forReference(wicketEventReference));
        return dependencies;
    }
}

