/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.request.Response;

public class FilteredHeaderItem
extends HeaderItem
implements IWrappedHeaderItem {
    private HeaderItem wrapped;
    private String filterName;

    public FilteredHeaderItem(HeaderItem wrapped, String filterName) {
        this.wrapped = wrapped;
        this.filterName = filterName;
    }

    @Override
    public HeaderItem getWrapped() {
        return this.wrapped;
    }

    @Override
    public FilteredHeaderItem wrap(HeaderItem item) {
        return new FilteredHeaderItem(item, this.getFilterName());
    }

    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return this.getWrapped().getRenderTokens();
    }

    @Override
    public void render(Response response) {
        this.getWrapped().render(response);
    }

    @Override
    public List<HeaderItem> getDependencies() {
        ArrayList<FilteredHeaderItem> ret = new ArrayList<FilteredHeaderItem>();
        for (HeaderItem curDependency : this.getWrapped().getDependencies()) {
            ret.add(this.wrap(curDependency));
        }
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.addAll(ret);
        return dependencies;
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        return this.getWrapped().getProvidedResources();
    }

    public int hashCode() {
        return this.getWrapped().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilteredHeaderItem) {
            return ((FilteredHeaderItem)obj).getWrapped().equals(this.getWrapped());
        }
        return false;
    }

    public String toString() {
        return "FilteredHeaderItem(" + this.getWrapped() + ", " + this.getFilterName() + ")";
    }
}

