/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.pages.BrowserInfoForm;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.cycle.RequestCycle;

public class BrowserInfoPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private BrowserInfoForm browserInfoForm;

    public BrowserInfoPage() {
        this.initComps();
        RequestCycle requestCycle = this.getRequestCycle();
        WebSession session = (WebSession)this.getSession();
        WebClientInfo clientInfo = session.getClientInfo();
        if (clientInfo == null) {
            clientInfo = new WebClientInfo(requestCycle);
            this.getSession().setClientInfo(clientInfo);
        } else {
            ClientProperties properties = clientInfo.getProperties();
            properties.setJavaEnabled(false);
        }
        this.continueToOriginalDestination();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(OnLoadHeaderItem.forScript(String.format("Wicket.BrowserInfo.submitForm('%s')", this.browserInfoForm.getFormMarkupId())));
    }

    @Override
    public boolean isVersioned() {
        return false;
    }

    private void initComps() {
        WebComponent meta = new WebComponent("meta");
        final LoadableDetachableModel<String> urlModel = new LoadableDetachableModel<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected String load() {
                CharSequence url = BrowserInfoPage.this.urlFor(BrowserInfoPage.class, null);
                return url.toString();
            }
        };
        meta.add(AttributeModifier.replace("content", new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getObject() {
                return "0; url=" + (String)urlModel.getObject();
            }
        }));
        this.add(meta);
        WebMarkupContainer link = new WebMarkupContainer("link");
        link.add(AttributeModifier.replace("href", urlModel));
        this.add(link);
        this.browserInfoForm = new BrowserInfoForm("postback"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void afterSubmit() {
                this.continueToOriginalDestination();
            }
        };
        this.add(this.browserInfoForm);
    }
}

