/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public final class HtmlHeaderSectionHandler
extends AbstractMarkupFilter {
    public static final String BODY = "body";
    public static final String HEAD = "head";
    public static final String HEADER_ID = "_header_";
    private boolean foundHead = false;
    private boolean foundClosingHead = false;
    private boolean foundHeaderItemsTag = false;
    private boolean ignoreTheRest = false;
    private final Markup markup;

    public HtmlHeaderSectionHandler(Markup markup) {
        super(markup.getMarkupResourceStream());
        this.markup = markup;
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (this.ignoreTheRest) {
            return tag;
        }
        if (HEAD.equalsIgnoreCase(tag.getName())) {
            if (tag.getNamespace() == null) {
                if (tag.isOpen()) {
                    this.foundHead = true;
                    if (tag.getId() == null) {
                        tag.setId(HEADER_ID);
                        tag.setAutoComponentTag(true);
                        tag.setModified(true);
                    }
                } else if (tag.isClose()) {
                    if (this.foundHeaderItemsTag) {
                        ComponentTag headOpenTag = tag.getOpenTag();
                        headOpenTag.setId("_header_-Ignored");
                        headOpenTag.setAutoComponentTag(false);
                        headOpenTag.setModified(false);
                        headOpenTag.setFlag(32, true);
                    }
                    this.foundClosingHead = true;
                }
                return tag;
            }
            this.foundHead = true;
            this.foundClosingHead = true;
        } else {
            if ("header-items".equalsIgnoreCase(tag.getName()) && tag.getNamespace().equalsIgnoreCase(this.getWicketNamespace())) {
                if (this.foundHeaderItemsTag) {
                    throw new MarkupException(new MarkupStream(this.markup), "More than one <wicket:header-items/> detected in the <head> element. Only one is allowed.");
                }
                if (this.foundClosingHead) {
                    throw new MarkupException(new MarkupStream(this.markup), "Detected <wicket:header-items/> after the closing </head> element.");
                }
                this.foundHeaderItemsTag = true;
                tag.setId(HEADER_ID);
                tag.setAutoComponentTag(true);
                tag.setModified(true);
                return tag;
            }
            if (BODY.equalsIgnoreCase(tag.getName()) && tag.getNamespace() == null) {
                if (this.foundHead && !this.foundClosingHead) {
                    throw new MarkupException(new MarkupStream(this.markup), "Invalid page markup. Tag <BODY> found inside <HEAD>");
                }
                if (!this.foundHead) {
                    this.insertHeadTag();
                }
                this.ignoreTheRest = true;
                return tag;
            }
        }
        return tag;
    }

    private void insertHeadTag() {
        ComponentTag openTag = new ComponentTag(HEAD, XmlTag.TagType.OPEN);
        openTag.setId(HEADER_ID);
        openTag.setAutoComponentTag(true);
        openTag.setModified(true);
        ComponentTag closeTag = new ComponentTag(HEAD, XmlTag.TagType.CLOSE);
        closeTag.setOpenTag(openTag);
        closeTag.setModified(true);
        this.markup.addMarkupElement(openTag);
        this.markup.addMarkupElement(closeTag);
    }
}

