/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelativePathPrefixHandler
extends AbstractMarkupFilter
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RelativePathPrefixHandler.class);
    public static final String WICKET_RELATIVE_PATH_PREFIX_CONTAINER_ID = "_relative_path_prefix_";
    private static final String[] attributeNames = new String[]{"href", "src", "background", "action"};
    public static final Behavior RELATIVE_PATH_BEHAVIOR = new Behavior(){
        private static final long serialVersionUID = 1L;

        @Override
        public void onComponentTag(Component component, ComponentTag tag) {
            for (String attrName : attributeNames) {
                String attrValue = tag.getAttributes().getString(attrName);
                if (attrValue == null || attrValue.startsWith("/") || attrValue.contains(":") || attrValue.startsWith("#")) continue;
                tag.getAttributes().put((Object)attrName, (Object)UrlUtils.rewriteToContextRelative((String)attrValue, (IRequestCycle)RequestCycle.get()));
            }
        }
    };
    private static final ComponentTag.IAutoComponentFactory FACTORY = new ComponentTag.IAutoComponentFactory(){

        @Override
        public Component newComponent(MarkupContainer container, ComponentTag tag) {
            return new TransparentWebMarkupContainer(tag.getId());
        }
    };
    private final AtomicInteger componentIndex = new AtomicInteger();

    public RelativePathPrefixHandler() {
        this(null);
    }

    public RelativePathPrefixHandler(MarkupResourceStream markup) {
        super(markup);
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag.isClose()) {
            return tag;
        }
        String wicketIdAttr = this.getWicketNamespace() + ":" + "id";
        if (tag instanceof WicketTag || tag.isAutolinkEnabled() || tag.getAttributes().get((Object)wicketIdAttr) != null) {
            return tag;
        }
        for (String attrName : attributeNames) {
            String attrValue = tag.getAttributes().getString(attrName);
            if (attrValue == null || attrValue.startsWith("/") || attrValue.contains(":") || attrValue.startsWith("#")) continue;
            if (tag.getId() == null) {
                tag.setId(this.getWicketRelativePathPrefix(null) + this.componentIndex.getAndIncrement());
                tag.setAutoComponentTag(true);
            }
            tag.addBehavior(RELATIVE_PATH_BEHAVIOR);
            tag.setModified(true);
            break;
        }
        return tag;
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag != null && tag.getId().startsWith(this.getWicketRelativePathPrefix(markupStream))) {
            return new TransparentWebMarkupContainer(tag.getId());
        }
        return null;
    }

    @Override
    public void postProcess(Markup markup) {
        for (MarkupElement next : markup) {
            ComponentTag componentTag;
            if (!(next instanceof ComponentTag) || !(componentTag = (ComponentTag)next).containsWicketId() || !componentTag.getId().startsWith(this.getWicketRelativePathPrefix(null))) continue;
            componentTag.setAutoComponentFactory(FACTORY);
        }
    }

    private String getWicketRelativePathPrefix(MarkupStream markupStream) {
        return this.getWicketNamespace(markupStream) + WICKET_RELATIVE_PATH_PREFIX_CONTAINER_ID;
    }
}

