/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.model.util.MapModel;
import org.apache.wicket.model.util.SetModel;
import org.apache.wicket.util.lang.Objects;

public class Model<T extends Serializable>
implements IModel<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    public Model() {
    }

    public Model(T object) {
        this.setObject(object);
    }

    public static <C> IModel<List<C>> ofList(List<C> list) {
        return new ListModel<C>(list);
    }

    public static <K, V> IModel<Map<K, V>> ofMap(Map<K, V> map) {
        return new MapModel<K, V>(map);
    }

    public static <C> IModel<Set<C>> ofSet(Set<C> set) {
        return new SetModel<C>(set);
    }

    public static <C> IModel<Collection<C>> of(Collection<C> collection) {
        return new CollectionModel<C>(collection);
    }

    public static <T extends Serializable> Model<T> of(T object) {
        return new Model<T>(object);
    }

    public static <T> IModel<T> of(IModel<?> model) {
        return model;
    }

    public static <T extends Serializable> Model<T> of() {
        return new Model<T>();
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T object) {
        if (object != null && !(object instanceof Serializable)) {
            throw new WicketRuntimeException("Model object must be Serializable");
        }
        this.object = object;
    }

    @Override
    public void detach() {
        if (this.object instanceof IDetachable) {
            ((IDetachable)this.object).detach();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append("]");
        sb.append(":object=[").append(this.object).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.object});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model that = (Model)obj;
        return Objects.equal(this.object, that.object);
    }
}

