/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.lang.ref.SoftReference;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractCachingPageStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.SecondLevelPageCache;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;

public class PerSessionPageStore
extends AbstractCachingPageStore<IManageablePage> {
    public PerSessionPageStore(ISerializer pageSerializer, IDataStore dataStore, int cacheSize) {
        super(pageSerializer, dataStore, new PagesCache(cacheSize));
    }

    @Override
    public IManageablePage convertToPage(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IManageablePage) {
            return (IManageablePage)object;
        }
        String type = object.getClass().getName();
        throw new IllegalArgumentException("Unknown object type: " + type);
    }

    protected static class PagesCache
    implements SecondLevelPageCache<String, Integer, IManageablePage> {
        private final int maxEntriesPerSession;
        private final ConcurrentMap<String, SoftReference<ConcurrentSkipListMap<PageValue, IManageablePage>>> cache;

        public PagesCache(int maxEntriesPerSession) {
            this.maxEntriesPerSession = maxEntriesPerSession;
            this.cache = new ConcurrentHashMap<String, SoftReference<ConcurrentSkipListMap<PageValue, IManageablePage>>>();
        }

        @Override
        public IManageablePage removePage(String sessionId, Integer pageId) {
            IManageablePage result = null;
            if (this.maxEntriesPerSession > 0) {
                ConcurrentMap pages;
                Args.notNull((Object)sessionId, (String)"sessionId");
                Args.notNull((Object)pageId, (String)"pageId");
                SoftReference pagesPerSession = (SoftReference)this.cache.get(sessionId);
                if (pagesPerSession != null && (pages = (ConcurrentMap)pagesPerSession.get()) != null) {
                    PageValue sample = new PageValue(pageId);
                    Iterator iterator = pages.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!sample.equals(entry.getKey())) continue;
                        result = (IManageablePage)entry.getValue();
                        iterator.remove();
                        break;
                    }
                }
            }
            return result;
        }

        @Override
        public void removePages(String sessionId) {
            Args.notNull((Object)sessionId, (String)"sessionId");
            if (this.maxEntriesPerSession > 0) {
                this.cache.remove(sessionId);
            }
        }

        @Override
        public IManageablePage getPage(String sessionId, Integer pageId) {
            IManageablePage result = null;
            if (this.maxEntriesPerSession > 0) {
                ConcurrentSkipListMap pages;
                Args.notNull((Object)sessionId, (String)"sessionId");
                Args.notNull((Object)pageId, (String)"pageId");
                SoftReference pagesPerSession = (SoftReference)this.cache.get(sessionId);
                if (pagesPerSession != null && (pages = (ConcurrentSkipListMap)pagesPerSession.get()) != null) {
                    PageValue sample = new PageValue(pageId);
                    for (Map.Entry entry : pages.entrySet()) {
                        if (!sample.equals(entry.getKey())) continue;
                        ((PageValue)entry.getKey()).touch();
                        result = (IManageablePage)entry.getValue();
                        break;
                    }
                }
            }
            return result;
        }

        @Override
        public void storePage(String sessionId, Integer pageId, IManageablePage page) {
            if (this.maxEntriesPerSession > 0) {
                ConcurrentSkipListMap<PageValue, IManageablePage> pages;
                SoftReference old;
                Args.notNull((Object)sessionId, (String)"sessionId");
                Args.notNull((Object)pageId, (String)"pageId");
                SoftReference pagesPerSession = (SoftReference)this.cache.get(sessionId);
                if (pagesPerSession == null && (old = this.cache.putIfAbsent(sessionId, pagesPerSession = new SoftReference(pages = new ConcurrentSkipListMap(new PageComparator())))) != null) {
                    pagesPerSession = old;
                }
                if ((pages = (ConcurrentSkipListMap)pagesPerSession.get()) == null && (old = this.cache.putIfAbsent(sessionId, pagesPerSession = new SoftReference(pages = new ConcurrentSkipListMap()))) != null) {
                    pages = old.get();
                }
                if (pages != null) {
                    this.removePage(sessionId, pageId);
                    PageValue pv = new PageValue(page);
                    pages.put(pv, page);
                    while (pages.size() > this.maxEntriesPerSession) {
                        pages.pollFirstEntry();
                    }
                }
            }
        }

        @Override
        public void destroy() {
            this.cache.clear();
        }

        private static class PageComparator
        implements Comparator<PageValue> {
            private PageComparator() {
            }

            @Override
            public int compare(PageValue p1, PageValue p2) {
                return Long.valueOf(p1.accessTime).compareTo(p2.accessTime);
            }
        }

        private static class PageValue {
            private final int pageId;
            private long accessTime;

            private PageValue(IManageablePage page) {
                this(page.getPageId());
            }

            private PageValue(int pageId) {
                this.pageId = pageId;
                this.touch();
            }

            private void touch() {
                this.accessTime = System.nanoTime();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PageValue pageValue = (PageValue)o;
                return this.pageId == pageValue.pageId;
            }

            public int hashCode() {
                return this.pageId;
            }
        }
    }
}

