/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import org.apache.wicket.MetaDataKey;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.pages.BrowserInfoPage;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;

public class WebSession
extends Session {
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<Boolean> BROWSER_WAS_POLLED_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };

    public static WebSession get() {
        return (WebSession)Session.get();
    }

    public WebSession(Request request) {
        super(request);
    }

    @Override
    public void invalidate() {
        if (!this.isSessionInvalidated()) {
            this.getApplication().getSecuritySettings().getAuthenticationStrategy().remove();
            super.invalidate();
        }
    }

    @Override
    public WebClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            RequestCycle requestCycle = RequestCycle.get();
            if (this.getApplication().getRequestCycleSettings().getGatherExtendedBrowserInfo()) {
                if (this.getMetaData(BROWSER_WAS_POLLED_KEY) == null) {
                    this.setMetaData(BROWSER_WAS_POLLED_KEY, Boolean.TRUE);
                    WebPage browserInfoPage = this.newBrowserInfoPage();
                    throw new RestartResponseAtInterceptPageException(browserInfoPage);
                }
                this.setMetaData(BROWSER_WAS_POLLED_KEY, null);
            }
            this.clientInfo = new WebClientInfo(requestCycle);
        }
        return (WebClientInfo)this.clientInfo;
    }

    protected WebPage newBrowserInfoPage() {
        return new BrowserInfoPage();
    }
}

