/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.page.PartialPageUpdate;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlPartialPageUpdate
extends PartialPageUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(XmlPartialPageUpdate.class);
    public static final String START_ROOT_ELEMENT = "<ajax-response>";
    public static final String END_ROOT_ELEMENT = "</ajax-response>";

    public XmlPartialPageUpdate(Page page) {
        super(page);
    }

    @Override
    public void setContentType(WebResponse response, String encoding) {
        response.setContentType("text/xml; charset=" + encoding);
    }

    @Override
    protected void writeHeader(Response response, String encoding) {
        response.write((CharSequence)"<?xml version=\"1.0\" encoding=\"");
        response.write((CharSequence)encoding);
        response.write((CharSequence)"\"?>");
        response.write((CharSequence)START_ROOT_ELEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeComponent(Response response, String markupId, Component component, String encoding) {
        Page page = component.findParent(Page.class);
        Response oldResponse = RequestCycle.get().setResponse((Response)this.bodyBuffer);
        try {
            this.writeHeaderContribution(response, component);
            this.bodyBuffer.reset();
            try {
                component.renderPart();
            }
            catch (RuntimeException e) {
                this.bodyBuffer.reset();
                throw e;
            }
        }
        finally {
            RequestCycle.get().setResponse(oldResponse);
        }
        response.write((CharSequence)"<component id=\"");
        response.write((CharSequence)markupId);
        response.write((CharSequence)"\" ><![CDATA[");
        response.write(this.encode(this.bodyBuffer.getContents()));
        response.write((CharSequence)"]]></component>");
        this.bodyBuffer.reset();
    }

    @Override
    protected void writeFooter(Response response, String encoding) {
        response.write((CharSequence)END_ROOT_ELEMENT);
    }

    @Override
    protected void writeHeaderContribution(Response response) {
        CharSequence contents = this.headerBuffer.getContents();
        if (!Strings.isEmpty((CharSequence)contents)) {
            response.write((CharSequence)"<header-contribution>");
            response.write((CharSequence)"<![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encode(contents));
            response.write((CharSequence)"</head>]]>");
            response.write((CharSequence)"</header-contribution>");
        }
    }

    @Override
    protected void writeNormalEvaluations(Response response, Collection<CharSequence> scripts) {
        this.writeEvaluations(response, "evaluate", scripts);
    }

    @Override
    protected void writePriorityEvaluations(Response response, Collection<CharSequence> scripts) {
        this.writeEvaluations(response, "priority-evaluate", scripts);
    }

    private void writeEvaluations(Response response, String elementName, Collection<CharSequence> scripts) {
        if (scripts.size() > 0) {
            StringBuilder combinedScript = new StringBuilder(1024);
            for (CharSequence script : scripts) {
                combinedScript.append("(function(){").append(script).append("})();");
            }
            this.writeEvaluation(elementName, response, combinedScript);
        }
    }

    private void writeEvaluation(String invocation, Response response, CharSequence js) {
        response.write((CharSequence)"<");
        response.write((CharSequence)invocation);
        response.write((CharSequence)">");
        response.write((CharSequence)"<![CDATA[");
        response.write(this.encode(js));
        response.write((CharSequence)"]]>");
        response.write((CharSequence)"</");
        response.write((CharSequence)invocation);
        response.write((CharSequence)">");
        this.bodyBuffer.reset();
    }

    protected CharSequence encode(CharSequence str) {
        return Strings.replaceAll((CharSequence)str, (CharSequence)"]]>", (CharSequence)"]]]]><![CDATA[>");
    }
}

