/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousDataStore
implements IDataStore {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousDataStore.class);
    private static final long OFFER_WAIT = 30L;
    private static final long POLL_WAIT = 1000L;
    private Thread pageSavingThread;
    private final IDataStore dataStore;
    private final BlockingQueue<Entry> entries;
    private final ConcurrentMap<String, Entry> entryMap;

    public AsynchronousDataStore(IDataStore dataStore, int capacity) {
        this.dataStore = dataStore;
        this.entries = new LinkedBlockingQueue<Entry>(capacity);
        this.entryMap = new ConcurrentHashMap<String, Entry>();
        this.pageSavingThread = new Thread((Runnable)new PageSavingRunnable(), "Wicket-AsyncDataStore-PageSavingThread");
        this.pageSavingThread.setDaemon(true);
        this.pageSavingThread.start();
    }

    @Override
    public void destroy() {
        Thread thread = this.pageSavingThread;
        this.pageSavingThread = null;
        if (thread != null && thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.dataStore.destroy();
    }

    private Entry getEntry(String sessionId, int id) {
        return (Entry)this.entryMap.get(AsynchronousDataStore.getKey(sessionId, id));
    }

    @Override
    public byte[] getData(String sessionId, int id) {
        Entry entry = this.getEntry(sessionId, id);
        if (entry != null) {
            log.debug("Returning the data of a non-stored entry with sessionId '{}' and pageId '{}'", (Object)sessionId, (Object)id);
            return entry.data;
        }
        byte[] data = this.dataStore.getData(sessionId, id);
        log.debug("Returning the data of a stored entry with sessionId '{}' and pageId '{}'", (Object)sessionId, (Object)id);
        return data;
    }

    @Override
    public boolean isReplicated() {
        return this.dataStore.isReplicated();
    }

    @Override
    public void removeData(String sessionId, int id) {
        Entry entry;
        String key = AsynchronousDataStore.getKey(sessionId, id);
        if (key != null && (entry = (Entry)this.entryMap.remove(key)) != null) {
            this.entries.remove(entry);
        }
        this.dataStore.removeData(sessionId, id);
    }

    @Override
    public void removeData(String sessionId) {
        Iterator itor = this.entries.iterator();
        while (itor.hasNext()) {
            String entrySessionId;
            Entry entry = (Entry)itor.next();
            if (entry == null || !sessionId.equals(entrySessionId = entry.sessionId)) continue;
            this.entryMap.remove(AsynchronousDataStore.getKey(entry));
            itor.remove();
        }
        this.dataStore.removeData(sessionId);
    }

    @Override
    public void storeData(String sessionId, int id, byte[] data) {
        block4: {
            if (this.pageSavingThread == null) {
                return;
            }
            Entry entry = new Entry(sessionId, id, data);
            String key = AsynchronousDataStore.getKey(entry);
            this.entryMap.put(key, entry);
            try {
                boolean added = this.entries.offer(entry, 30L, TimeUnit.MILLISECONDS);
                if (!added) {
                    log.debug("Storing synchronously page with id '{}' in session '{}'", (Object)id, (Object)sessionId);
                    this.entryMap.remove(key);
                    this.dataStore.storeData(sessionId, id, data);
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.pageSavingThread == null) break block4;
                this.entryMap.remove(key);
                this.dataStore.storeData(sessionId, id, data);
            }
        }
    }

    private static String getKey(String sessionId, int pageId) {
        return pageId + ":::" + sessionId;
    }

    private static String getKey(Entry entry) {
        return AsynchronousDataStore.getKey(entry.sessionId, entry.pageId);
    }

    @Override
    public final boolean canBeAsynchronous() {
        return false;
    }

    private class PageSavingRunnable
    implements Runnable {
        private PageSavingRunnable() {
        }

        @Override
        public void run() {
            while (AsynchronousDataStore.this.pageSavingThread != null) {
                Entry entry = null;
                try {
                    entry = (Entry)AsynchronousDataStore.this.entries.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.debug("PageSavingRunnable:: Interrupted...");
                }
                if (entry == null || AsynchronousDataStore.this.pageSavingThread == null) continue;
                log.debug("PageSavingRunnable:: Saving asynchronously: {}...", (Object)entry);
                AsynchronousDataStore.this.dataStore.storeData(entry.sessionId, entry.pageId, entry.data);
                AsynchronousDataStore.this.entryMap.remove(AsynchronousDataStore.getKey(entry));
            }
        }
    }

    private static class Entry {
        private final String sessionId;
        private final int pageId;
        private final byte[] data;

        public Entry(String sessionId, int pageId, byte[] data) {
            this.sessionId = (String)Args.notNull((Object)sessionId, (String)"sessionId");
            this.pageId = pageId;
            this.data = (byte[])Args.notNull((Object)data, (String)"data");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pageId;
            result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.pageId != other.pageId) {
                return false;
            }
            return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
        }

        public String toString() {
            return "Entry [sessionId=" + this.sessionId + ", pageId=" + this.pageId + "]";
        }
    }
}

