/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public class BookmarkablePageRequestHandler
implements IPageClassRequestHandler,
ILoggableRequestHandler {
    private final IPageProvider pageProvider;
    private PageLogData logData;

    public BookmarkablePageRequestHandler(IPageProvider pageProvider) {
        Args.notNull((Object)pageProvider, (String)"pageProvider");
        this.pageProvider = pageProvider;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageProvider.getPageClass();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageProvider.getPageParameters();
    }

    public void respond(IRequestCycle requestCycle) {
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new PageLogData(this.pageProvider);
        }
    }

    public PageLogData getLogData() {
        return this.logData;
    }

    public String toString() {
        return "BookmarkablePageRequestHandler{pageProvider=" + this.pageProvider + '}';
    }
}

