/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.IOException;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.mock.MockApplication;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.DiffUtil;
import org.apache.wicket.util.tester.WicketTester;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class WicketTestCase
extends Assert {
    public WicketTester tester;

    @Before
    public void commonBefore() {
        ThreadContext.detach();
        WebApplication application = this.newApplication();
        this.tester = this.newWicketTester(application);
    }

    protected WebApplication newApplication() {
        return new MockApplication();
    }

    protected WicketTester newWicketTester(WebApplication app) {
        return new WicketTester(app){

            @Override
            protected Locale servletRequestLocale() {
                return Locale.US;
            }
        };
    }

    @After
    public void commonAfter() {
        this.tester.destroy();
    }

    protected <T extends Page> void executeTest(Class<T> pageClass, String filename) throws Exception {
        this.tester.executeTest(((Object)((Object)this)).getClass(), pageClass, filename);
    }

    protected void executeTest(Page page, String filename) throws Exception {
        this.tester.executeTest(((Object)((Object)this)).getClass(), page, filename);
    }

    protected <T extends Page> void executeTest(Class<T> pageClass, PageParameters parameters, String filename) throws Exception {
        this.tester.executeTest(((Object)((Object)this)).getClass(), pageClass, parameters, filename);
    }

    protected void executeListener(Component component, String filename) throws Exception {
        this.tester.executeListener(((Object)((Object)this)).getClass(), component, filename);
    }

    protected void executeBehavior(AbstractAjaxBehavior behavior, String filename) throws Exception {
        this.tester.executeBehavior(((Object)((Object)this)).getClass(), behavior, filename);
    }

    public String getBasedir() {
        return WicketTester.getBasedir();
    }

    public final void compareMarkupWithFile(IMarkupFragment markup, String filename, Class<?> scopeClass) throws IOException {
        String doc = markup.toString(true);
        DiffUtil.validatePage(doc, scopeClass, filename, true);
    }

    public final void compareMarkupWithString(IMarkupFragment markup, String testMarkup) throws IOException {
        testMarkup = testMarkup.replaceAll("\r", "");
        testMarkup = testMarkup.replaceAll("\n", "");
        testMarkup = testMarkup.replaceAll("\t", "");
        String doc = markup.toString(true);
        doc = doc.replaceAll("\n", "");
        doc = doc.replaceAll("\r", "");
        doc = doc.replaceAll("\t", "");
        WicketTestCase.assertEquals((Object)doc, (Object)testMarkup);
    }
}

