/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.panel.AssociatedMarkupSourcingStrategy;

public class PanelMarkupSourcingStrategy
extends AssociatedMarkupSourcingStrategy {
    private final boolean allowWicketComponentsInBodyMarkup;

    public PanelMarkupSourcingStrategy(String wicketTagName, boolean allowWicketComponentsInBodyMarkup) {
        super(wicketTagName);
        this.allowWicketComponentsInBodyMarkup = allowWicketComponentsInBodyMarkup;
    }

    public PanelMarkupSourcingStrategy(boolean allowWicketComponentsInBodyMarkup) {
        this("panel", allowWicketComponentsInBodyMarkup);
    }

    @Override
    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        if (this.allowWicketComponentsInBodyMarkup) {
            markupStream.skipToMatchingCloseTag(openTag);
        } else if (markupStream.getPreviousTag().isOpen()) {
            markupStream.skipRawMarkup();
            if (!markupStream.get().closes(openTag)) {
                StringBuilder msg = new StringBuilder();
                msg.append("Close tag not found for tag: ").append(openTag.toString()).append(". For ").append(component.getClass().getSimpleName()).append(" Components only raw markup is allow in between the tags but not ").append("other Wicket Component. Component: ").append(component.toString());
                throw new MarkupException(markupStream, msg.toString());
            }
        }
        this.renderAssociatedMarkup(component);
    }
}

