/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.wicket.Application;
import org.apache.wicket.IMetadataContext;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.feedback.IFeedbackContributor;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.PageAccessSynchronizer;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.LazyInitializer;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Session
implements IClusterable,
IEventSink,
IMetadataContext<Serializable, Session>,
IFeedbackContributor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private static final MetaDataKey<Boolean> SESSION_INVALIDATED = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    public static final String SESSION_ATTRIBUTE_NAME = "session";
    private final AtomicInteger sequence = new AtomicInteger(1);
    private final AtomicInteger pageId = new AtomicInteger(0);
    private final Supplier<PageAccessSynchronizer> pageAccessSynchronizer;
    protected ClientInfo clientInfo;
    private volatile transient boolean dirty = false;
    private final FeedbackMessages feedbackMessages = new FeedbackMessages();
    private volatile String id = null;
    private final AtomicReference<Locale> locale;
    private MetaDataEntry<?>[] metaData;
    private transient ISessionStore sessionStore;
    private final AtomicReference<String> style = new AtomicReference();
    private transient Map<String, Serializable> temporarySessionAttributes;

    public static boolean exists() {
        RequestCycle requestCycle;
        Session session = ThreadContext.getSession();
        if (session == null && (requestCycle = RequestCycle.get()) != null && (session = Application.get().getSessionStore().lookup(requestCycle.getRequest())) != null) {
            ThreadContext.setSession(session);
        }
        return session != null;
    }

    public static Session get() {
        Session session = ThreadContext.getSession();
        if (session != null) {
            return session;
        }
        return Application.get().fetchCreateAndSetSession(RequestCycle.get());
    }

    public Session(Request request) {
        Locale locale = request.getLocale();
        if (locale == null) {
            throw new IllegalStateException("Request#getLocale() cannot return null, request has to have a locale set on it");
        }
        this.locale = new AtomicReference<Locale>(locale);
        this.pageAccessSynchronizer = new PageAccessSynchronizerProvider();
    }

    public final void bind() {
        Request request;
        if (RequestCycle.get() == null) {
            return;
        }
        ISessionStore store = this.getSessionStore();
        if (store.lookup(request = RequestCycle.get().getRequest()) == null) {
            this.id = store.getSessionId(request, true);
            store.bind(request, this);
            if (this.temporarySessionAttributes != null) {
                for (Map.Entry<String, Serializable> entry : this.temporarySessionAttributes.entrySet()) {
                    store.setAttribute(request, entry.getKey(), entry.getValue());
                }
                this.temporarySessionAttributes = null;
            }
        }
    }

    public final void clear() {
        if (!this.isTemporary()) {
            this.getPageManager().removeAllPages();
        }
    }

    @Override
    public final void error(Serializable message) {
        this.addFeedbackMessage(message, 400);
    }

    @Override
    public final void fatal(Serializable message) {
        this.addFeedbackMessage(message, 500);
    }

    @Override
    public final void debug(Serializable message) {
        this.addFeedbackMessage(message, 100);
    }

    public final Application getApplication() {
        return Application.get();
    }

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.getApplication().getSecuritySettings().getAuthorizationStrategy();
    }

    public final IClassResolver getClassResolver() {
        return this.getApplication().getApplicationSettings().getClassResolver();
    }

    public abstract ClientInfo getClientInfo();

    public final FeedbackMessages getFeedbackMessages() {
        return this.feedbackMessages;
    }

    public final String getId() {
        if (this.id == null) {
            this.updateId();
            if (this.id != null) {
                this.dirty();
            }
        }
        return this.id;
    }

    private void updateId() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null) {
            this.id = this.getSessionStore().getSessionId(requestCycle.getRequest(), false);
        }
    }

    public Locale getLocale() {
        return this.locale.get();
    }

    @Override
    public final synchronized <M extends Serializable> M getMetaData(MetaDataKey<M> key) {
        return (M)((Serializable)key.get(this.metaData));
    }

    public IPageFactory getPageFactory() {
        return this.getApplication().getPageFactory();
    }

    public final long getSizeInBytes() {
        return WicketObjects.sizeof((Serializable)((Object)this));
    }

    public final String getStyle() {
        return this.style.get();
    }

    @Override
    public final void info(Serializable message) {
        this.addFeedbackMessage(message, 200);
    }

    @Override
    public final void success(Serializable message) {
        this.addFeedbackMessage(message, 250);
    }

    public void invalidate() {
        RequestCycle.get().setMetaData((MetaDataKey)SESSION_INVALIDATED, (Object)true);
    }

    private void destroy() {
        if (this.getSessionStore() != null) {
            this.sessionStore.invalidate(RequestCycle.get().getRequest());
            this.sessionStore = null;
            this.id = null;
            RequestCycle.get().setMetaData((MetaDataKey)SESSION_INVALIDATED, (Object)false);
            this.clientInfo = null;
            this.dirty = false;
            this.metaData = null;
        }
    }

    public void invalidateNow() {
        if (!this.isSessionInvalidated()) {
            this.invalidate();
        }
        this.destroy();
        this.feedbackMessages.clear();
        this.setStyle(null);
        this.pageId.set(0);
        this.sequence.set(0);
        this.temporarySessionAttributes = null;
    }

    public void replaceSession() {
        this.destroy();
        this.bind();
    }

    public final boolean isSessionInvalidated() {
        return Boolean.TRUE.equals(RequestCycle.get().getMetaData(SESSION_INVALIDATED));
    }

    public final boolean isTemporary() {
        return this.getId() == null;
    }

    public final Session setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        this.dirty();
        return this;
    }

    public Session setLocale(Locale locale) {
        Args.notNull((Object)locale, (String)"locale");
        if (!Objects.equal((Object)this.getLocale(), (Object)locale)) {
            this.locale.set(locale);
            this.dirty();
        }
        return this;
    }

    @Override
    public final synchronized <M extends Serializable> Session setMetaData(MetaDataKey<M> key, M object) {
        this.metaData = key.set(this.metaData, object);
        this.dirty();
        return this;
    }

    public final Session setStyle(String style) {
        if (!Objects.equal((Object)this.getStyle(), (Object)style)) {
            this.style.set(style);
            this.dirty();
        }
        return this;
    }

    @Override
    public final void warn(Serializable message) {
        this.addFeedbackMessage(message, 300);
    }

    private void addFeedbackMessage(Serializable message, int level) {
        this.getFeedbackMessages().add(null, message, level);
        this.dirty();
    }

    public void detach() {
        this.detachFeedback();
        if (this.isSessionInvalidated()) {
            this.invalidateNow();
        } else if (!this.isTemporary()) {
            this.updateId();
        }
    }

    private void detachFeedback() {
        int removed = this.feedbackMessages.clear(this.getApplication().getApplicationSettings().getFeedbackMessageCleanupFilter());
        if (removed != 0) {
            this.dirty();
        }
        this.feedbackMessages.detach();
    }

    public void internalDetach() {
        if (this.dirty) {
            Request request = RequestCycle.get().getRequest();
            this.getSessionStore().flushSession(request, this);
        }
        this.dirty = false;
    }

    public final void dirty() {
        this.dirty(true);
    }

    public final void dirty(boolean forced) {
        if (this.isTemporary()) {
            if (forced) {
                this.dirty = true;
            }
        } else {
            this.dirty = true;
        }
    }

    public final Serializable getAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return this.getSessionStore().getAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            return this.temporarySessionAttributes.get(name);
        }
        return null;
    }

    public final List<String> getAttributeNames() {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return Collections.unmodifiableList(this.getSessionStore().getAttributeNames(cycle.getRequest()));
            }
        } else if (this.temporarySessionAttributes != null) {
            return Collections.unmodifiableList(new ArrayList<String>(this.temporarySessionAttributes.keySet()));
        }
        return Collections.emptyList();
    }

    protected ISessionStore getSessionStore() {
        if (this.sessionStore == null) {
            this.sessionStore = this.getApplication().getSessionStore();
        }
        return this.sessionStore;
    }

    public final void removeAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                this.getSessionStore().removeAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            this.temporarySessionAttributes.remove(name);
        }
    }

    public final Session setAttribute(String name, Serializable value) {
        if (!this.isTemporary()) {
            String id;
            Serializable current;
            RequestCycle cycle = RequestCycle.get();
            if (cycle == null) {
                throw new IllegalStateException("Cannot set the attribute: no RequestCycle available.  If you get this error when using WicketTester.startPage(Page), make sure to call WicketTester.createRequestCycle() beforehand.");
            }
            ISessionStore store = this.getSessionStore();
            Request request = cycle.getRequest();
            if (value == this && (current = store.getAttribute(request, name)) == null && (id = store.getSessionId(request, false)) != null) {
                store.bind(request, (Session)((Object)value));
            }
            store.setAttribute(request, name, value);
        } else {
            if (this.temporarySessionAttributes == null) {
                this.temporarySessionAttributes = new HashMap<String, Serializable>(3);
            }
            this.temporarySessionAttributes.put(name, value);
        }
        return this;
    }

    public int nextSequenceValue() {
        this.dirty(false);
        return this.sequence.getAndIncrement();
    }

    public int nextPageId() {
        this.dirty(false);
        return this.pageId.getAndIncrement();
    }

    public final IPageManager getPageManager() {
        IPageManager manager = Application.get().internalGetPageManager();
        return this.pageAccessSynchronizer.get().adapt(manager);
    }

    @Override
    public void onEvent(IEvent<?> event) {
    }

    public void onInvalidate() {
    }

    public void changeSessionId() {
        if (this.isTemporary()) {
            return;
        }
        this.id = this.generateNewSessionId();
    }

    protected abstract String generateNewSessionId();

    protected PageAccessSynchronizer newPageAccessSynchronizer(Duration timeout) {
        return new PageAccessSynchronizer(timeout);
    }

    private final class PageAccessSynchronizerProvider
    extends LazyInitializer<PageAccessSynchronizer> {
        private static final long serialVersionUID = 1L;

        private PageAccessSynchronizerProvider() {
        }

        protected PageAccessSynchronizer createInstance() {
            Duration timeout;
            if (Application.exists()) {
                timeout = Application.get().getRequestCycleSettings().getTimeout();
            } else {
                timeout = Duration.minutes((int)1);
                log.warn("PageAccessSynchronizer created outside of application thread, using default timeout: {}", (Object)timeout);
            }
            return Session.this.newPageAccessSynchronizer(timeout);
        }
    }
}

