/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class ListMultipleChoice<T>
extends AbstractChoice<Collection<T>, T> {
    private static final long serialVersionUID = 1L;
    static MetaDataKey<Boolean> RETAIN_DISABLED_META_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    private static final int DEFAULT_MAX_ROWS = 8;
    private int maxRows = 8;

    public ListMultipleChoice(String id) {
        super(id);
    }

    public ListMultipleChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public ListMultipleChoice(String id, List<? extends T> choices, int maxRows) {
        super(id, choices);
        this.maxRows = maxRows;
    }

    public ListMultipleChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> object, List<? extends T> choices) {
        super(id, object, choices);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> object, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, object, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public ListMultipleChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public final ListMultipleChoice<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public final String getModelValue() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        Collection selectedValues = (Collection)this.getModelObject();
        if (selectedValues != null) {
            List choices = this.getChoices();
            for (Object object : selectedValues) {
                if (buffer.length() > 0) {
                    buffer.append(";");
                }
                int index = choices.indexOf(object);
                buffer.append(this.getChoiceRenderer().getIdValue(object, index));
            }
        }
        return buffer.toString();
    }

    @Override
    protected final boolean isSelected(T choice, int index, String selected) {
        if (selected != null) {
            String idValue = this.getChoiceRenderer().getIdValue(choice, index);
            StringTokenizer tokenizer = new StringTokenizer(selected, ";");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                if (!id.equals(idValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("multiple", "multiple");
        if (!tag.getAttributes().containsKey((Object)"size")) {
            tag.put("size", Math.min(this.maxRows, this.getChoices().size()));
        }
    }

    @Override
    protected Collection<T> convertValue(String[] ids) throws ConversionException {
        if (ids != null && ids.length > 0 && !Strings.isEmpty((CharSequence)ids[0])) {
            return this.convertChoiceIdsToChoices(ids);
        }
        ArrayList result = new ArrayList();
        this.addRetainedDisabled(result);
        return result;
    }

    protected List<T> convertChoiceIdsToChoices(String[] ids) {
        ArrayList<T> selectedValues = new ArrayList<T>();
        if (ids != null && ids.length > 0 && !Strings.isEmpty((CharSequence)ids[0])) {
            Map<String, T> choiceIds2choiceValues = this.createChoicesIdsMap();
            for (String id : ids) {
                if (!choiceIds2choiceValues.containsKey(id)) continue;
                selectedValues.add(choiceIds2choiceValues.get(id));
            }
        }
        this.addRetainedDisabled(selectedValues);
        return selectedValues;
    }

    private Map<String, T> createChoicesIdsMap() {
        List choices = this.getChoices();
        HashMap choiceIds2choiceValues = new HashMap(choices.size(), 1.0f);
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            choiceIds2choiceValues.put(this.getChoiceRenderer().getIdValue(choice, index), choice);
        }
        return choiceIds2choiceValues;
    }

    private void addRetainedDisabled(ArrayList<T> selectedValues) {
        if (this.isRetainDisabledSelected()) {
            Collection unchangedModel = (Collection)this.getModelObject();
            StringBuilder builder = new StringBuilder();
            for (Object t : unchangedModel) {
                builder.append(t);
                builder.append(';');
            }
            String selected = builder.toString();
            List choices = this.getChoices();
            for (int i = 0; i < choices.size(); ++i) {
                Object choice = choices.get(i);
                if (!this.isDisabled(choice, i, selected) || !unchangedModel.contains(choice) || selectedValues.contains(choice)) continue;
                selectedValues.add(choice);
            }
        }
    }

    @Override
    public void updateModel() {
        FormComponent.updateCollectionModel(this);
    }

    public boolean isRetainDisabledSelected() {
        Boolean flag = (Boolean)this.getMetaData((MetaDataKey)RETAIN_DISABLED_META_KEY);
        return flag != null && flag != false;
    }

    public ListMultipleChoice<T> setRetainDisabledSelected(boolean retain) {
        this.setMetaData(RETAIN_DISABLED_META_KEY, retain ? Boolean.valueOf(true) : null);
        return this;
    }
}

