/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class Link<T>
extends AbstractLink
implements IRequestListener,
IGenericComponent<T, Link<T>> {
    private static final long serialVersionUID = 1L;
    private Component anchor;
    private boolean autoEnable = false;
    private PopupSettings popupSettings = null;

    public Link(String id) {
        super(id);
    }

    public Link(String id, IModel<T> model) {
        super(id, model);
    }

    public Component getAnchor() {
        return this.anchor;
    }

    public final boolean getAutoEnable() {
        return this.autoEnable;
    }

    public final PopupSettings getPopupSettings() {
        return this.popupSettings;
    }

    @Override
    public boolean isEnabled() {
        if (this.getAutoEnable()) {
            return !this.linksTo(this.getPage());
        }
        return super.isEnabled();
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }

    public abstract void onClick();

    @Override
    public void onRequest() {
        this.onClick();
    }

    public Link<T> setAnchor(Component anchor) {
        this.addStateChange();
        this.anchor = anchor;
        return this;
    }

    public final Link<T> setAutoEnable(boolean autoEnable) {
        this.autoEnable = autoEnable;
        return this;
    }

    public final Link<T> setPopupSettings(PopupSettings popupSettings) {
        this.popupSettings = popupSettings;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CharSequence appendAnchor(ComponentTag tag, CharSequence url) {
        if (url == null) return url;
        Component anchor = this.getAnchor();
        if (anchor != null) {
            if (url.toString().indexOf(35) != -1) return url;
            String id = anchor.getOutputMarkupId() ? anchor.getMarkupId() : anchor.getMarkupAttributes().getString("id");
            if (id == null) throw new WicketRuntimeException("an achor component was set on " + this + " but it neither has outputMarkupId set to true nor has a id set explicitly");
            return (CharSequence)url + "#" + anchor.getMarkupId();
        }
        if (!tag.getName().equalsIgnoreCase("a")) return url;
        if (url.toString().indexOf(35) != -1) return url;
        String href = tag.getAttributes().getString("href");
        if (href == null) return url;
        if (href.length() <= 1) return url;
        if (href.charAt(0) != '#') return url;
        return (CharSequence)url + href;
    }

    protected CharSequence getOnClickScript(CharSequence url) {
        return null;
    }

    protected CharSequence getURL() {
        return this.urlForListener(new PageParameters());
    }

    protected boolean linksTo(Page page) {
        return false;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnabledInHierarchy()) {
            CharSequence onClickJavaScript;
            CharSequence url = this.getURL();
            url = this.appendAnchor(tag, url);
            if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                tag.put("href", url);
                if (this.popupSettings != null) {
                    tag.put("onclick", this.popupSettings.getPopupJavaScript());
                }
            } else if (tag.getName().equalsIgnoreCase("script") || tag.getName().equalsIgnoreCase("style")) {
                tag.put("src", url);
            } else if (this.popupSettings != null) {
                this.popupSettings.setTarget("'" + url + "'");
                String popupScript = this.popupSettings.getPopupJavaScript();
                tag.put("onclick", popupScript);
            } else {
                tag.put("onclick", "var win = this.ownerDocument.defaultView || this.ownerDocument.parentWindow; if (win == window) { window.location.href='" + url + "'; } ;return false");
            }
            if ((onClickJavaScript = this.getOnClickScript(url)) != null) {
                tag.put("onclick", onClickJavaScript);
            }
        } else {
            this.disableLink(tag);
        }
    }
}

