/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.DisabledAttributeLinkBehavior;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoLinkResolver
implements IComponentResolver {
    private static final TagReferenceResolver DEFAULT_ATTRIBUTE_RESOLVER = new TagReferenceResolver("href");
    private static final Logger log = LoggerFactory.getLogger(AutoLinkResolver.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, IAutolinkResolverDelegate> tagNameToAutolinkResolverDelegates = new HashMap<String, IAutolinkResolverDelegate>();
    private final Map<String, ITagReferenceResolver> tagNameToTagReferenceResolvers = new HashMap<String, ITagReferenceResolver>();

    public AutoLinkResolver() {
        TagReferenceResolver hrefTagReferenceResolver = new TagReferenceResolver("href");
        TagReferenceResolver srcTagReferenceResolver = new TagReferenceResolver("src");
        this.tagNameToTagReferenceResolvers.put("a", hrefTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("link", hrefTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("script", srcTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("img", srcTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("input", srcTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("embed", srcTagReferenceResolver);
        this.tagNameToAutolinkResolverDelegates.put("a", new AnchorResolverDelegate());
        this.tagNameToAutolinkResolverDelegates.put("link", new ResourceReferenceResolverDelegate("href"));
        ResourceReferenceResolverDelegate srcResRefResolver = new ResourceReferenceResolverDelegate("src");
        this.tagNameToAutolinkResolverDelegates.put("script", srcResRefResolver);
        this.tagNameToAutolinkResolverDelegates.put("img", srcResRefResolver);
        this.tagNameToAutolinkResolverDelegates.put("input", srcResRefResolver);
        this.tagNameToAutolinkResolverDelegates.put("embed", srcResRefResolver);
    }

    public final void addTagReferenceResolver(String tagName, String attributeName, IAutolinkResolverDelegate resolver) {
        TagReferenceResolver tagReferenceResolver = new TagReferenceResolver(attributeName);
        this.tagNameToTagReferenceResolvers.put(tagName, tagReferenceResolver);
        this.tagNameToAutolinkResolverDelegates.put(tagName, resolver);
    }

    public final IAutolinkResolverDelegate getAutolinkResolverDelegate(String tagName) {
        return this.tagNameToAutolinkResolverDelegates.get(tagName);
    }

    @Override
    public final Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag.isAutolinkEnabled()) {
            ITagReferenceResolver referenceResolver = this.tagNameToTagReferenceResolvers.get(tag.getName());
            if (referenceResolver == null) {
                referenceResolver = DEFAULT_ATTRIBUTE_RESOLVER;
            }
            String reference = referenceResolver.getReference(tag);
            PathInfo pathInfo = new PathInfo(reference, container, markupStream);
            Component link = this.resolveAutomaticLink(pathInfo, tag);
            if (log.isDebugEnabled()) {
                log.debug("Added autolink " + link);
            }
            return link;
        }
        return null;
    }

    private Component resolveAutomaticLink(PathInfo pathInfo, ComponentTag tag) {
        String componentId = tag.getId();
        String tagName = tag.getName();
        if (tag.getId() == null) {
            tag.setAutoComponentTag(true);
        }
        IAutolinkResolverDelegate autolinkResolverDelegate = this.tagNameToAutolinkResolverDelegates.get(tagName);
        Component autoComponent = null;
        if (autolinkResolverDelegate != null) {
            autoComponent = autolinkResolverDelegate.newAutoComponent(componentId, pathInfo);
        }
        if (autoComponent == null) {
            autoComponent = new TransparentWebMarkupContainer(componentId);
        }
        return autoComponent;
    }

    private static final class TagReferenceResolver
    implements ITagReferenceResolver {
        private final String attribute;

        public TagReferenceResolver(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public String getReference(ComponentTag tag) {
            return tag.getAttributes().getString(this.attribute);
        }
    }

    private static final class ResourceReferenceResolverDelegate
    extends AbstractAutolinkResolverDelegate {
        private final String attribute;

        public ResourceReferenceResolverDelegate(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Component newAutoComponent(String autoId, PathInfo pathInfo) {
            return this.newPackageResourceReferenceAutoComponent(autoId, pathInfo, this.attribute);
        }
    }

    private static final class ResourceReferenceAutolink
    extends WebMarkupContainer
    implements IComponentResolver {
        private static final long serialVersionUID = 1L;
        private final String attribute;
        private final ResourceReference resourceReference;
        private final MarkupContainer parent;

        public ResourceReferenceAutolink(String id, Class<?> clazz, String href, String attribute, MarkupContainer parent) {
            super(id);
            this.parent = parent;
            this.attribute = attribute;
            this.resourceReference = PackageResource.exists(clazz, href, this.getLocale(), this.getStyle(), this.getVariation()) ? new PackageResourceReference(clazz, href, null, null, null) : null;
        }

        @Override
        public String getVariation() {
            if (this.parent != null) {
                return this.parent.getVariation();
            }
            return super.getVariation();
        }

        @Override
        protected final void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (this.resourceReference != null) {
                ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(this.resourceReference);
                CharSequence url = this.getRequestCycle().urlFor(handler);
                tag.put(this.attribute, url);
            }
        }

        @Override
        public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
            return this.getParent().get(tag.getId());
        }
    }

    private static interface ITagReferenceResolver {
        public String getReference(ComponentTag var1);
    }

    private static final class AnchorResolverDelegate
    extends AbstractAutolinkResolverDelegate {
        private static final String attribute = "href";
        private final Set<String> supportedPageExtensions = new HashSet<String>(4);

        public AnchorResolverDelegate() {
            this.supportedPageExtensions.add("html");
            this.supportedPageExtensions.add("xml");
            this.supportedPageExtensions.add("wml");
            this.supportedPageExtensions.add("svg");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Component newAutoComponent(String autoId, PathInfo pathInfo) {
            MarkupContainer container = pathInfo.getContainer();
            if (pathInfo.extension == null || !this.supportedPageExtensions.contains(pathInfo.extension)) return this.newPackageResourceReferenceAutoComponent(autoId, pathInfo, attribute);
            Page page = container.getPage();
            IClassResolver defaultClassResolver = page.getApplication().getApplicationSettings().getClassResolver();
            String className = Packages.absolutePath(page.getClass(), (String)pathInfo.path);
            if ((className = Strings.replaceAll((CharSequence)className, (CharSequence)"/", (CharSequence)".").toString()).startsWith(".")) {
                className = className.substring(1);
            }
            try {
                Class<?> clazz = defaultClassResolver.resolveClass(className);
                return new AutolinkBookmarkablePageLink(autoId, clazz, pathInfo.pageParameters, pathInfo.anchor);
            }
            catch (ClassNotFoundException ex) {
                ComponentTag tag;
                Class<? extends Component> clazz;
                IMarkupFragment containerMarkup;
                MarkupStream containerMarkupStream;
                log.warn("Did not find corresponding java class: " + className);
                MarkupContainer parentWithContainer = container;
                if (container.getParent() != null) {
                    parentWithContainer = container.findParentWithAssociatedMarkup();
                }
                if (!(parentWithContainer instanceof Page) || pathInfo.path.startsWith("/") || !new MarkupStream(page.getMarkup()).isMergedMarkup() || !(containerMarkupStream = new MarkupStream(containerMarkup = container.getMarkup())).atTag() || (clazz = (tag = containerMarkupStream.getTag()).getMarkupClass()) == null) return null;
                className = Packages.absolutePath(clazz, (String)pathInfo.path);
                if ((className = Strings.replaceAll((CharSequence)className, (CharSequence)"/", (CharSequence)".").toString()).startsWith(".")) {
                    className = className.substring(1);
                }
                try {
                    Class<?> clazz2 = defaultClassResolver.resolveClass(className);
                    return new AutolinkBookmarkablePageLink(autoId, clazz2, pathInfo.getPageParameters(), pathInfo.anchor);
                }
                catch (ClassNotFoundException ex2) {
                    log.warn("Did not find corresponding java class: " + className);
                    return null;
                }
            }
        }
    }

    public static final class PathInfo {
        private final boolean absolute;
        private final String anchor;
        private final String extension;
        private final PageParameters pageParameters;
        private final String path;
        private final String reference;
        private final MarkupContainer container;
        private final MarkupStream markupStream;

        public PathInfo(String reference, MarkupContainer container, MarkupStream markupStream) {
            String infoPath;
            this.reference = reference;
            this.container = container;
            this.markupStream = markupStream;
            int queryStringPos = reference.indexOf("?");
            if (queryStringPos != -1) {
                String queryString = reference.substring(queryStringPos + 1);
                this.pageParameters = new PageParameters();
                RequestUtils.decodeParameters(queryString, this.pageParameters);
                infoPath = reference.substring(0, queryStringPos);
            } else {
                this.pageParameters = null;
                infoPath = reference;
            }
            this.absolute = infoPath.startsWith("/") || infoPath.startsWith("\\");
            String extension = null;
            int pos = infoPath.lastIndexOf(".");
            if (pos != -1) {
                extension = infoPath.substring(pos + 1);
                infoPath = infoPath.substring(0, pos);
            }
            String anchor = null;
            if (extension != null && (pos = extension.indexOf(35)) != -1) {
                anchor = extension.substring(pos);
                extension = extension.substring(0, pos);
            }
            if (anchor == null && (pos = infoPath.indexOf("#")) != -1) {
                anchor = infoPath.substring(pos);
                infoPath = infoPath.substring(0, pos);
            }
            this.path = infoPath;
            this.extension = extension;
            this.anchor = anchor;
        }

        public final String getAnchor() {
            return this.anchor;
        }

        public final String getExtension() {
            return this.extension;
        }

        public final PageParameters getPageParameters() {
            return this.pageParameters;
        }

        public final String getPath() {
            return this.path;
        }

        public final String getReference() {
            return this.reference;
        }

        public final boolean isAbsolute() {
            return this.absolute;
        }

        public MarkupContainer getContainer() {
            return this.container;
        }

        public MarkupStream getMarkupStream() {
            return this.markupStream;
        }
    }

    public static interface IAutolinkResolverDelegate {
        public Component newAutoComponent(String var1, PathInfo var2);
    }

    public static final class AutolinkBookmarkablePageLink<T>
    extends BookmarkablePageLink<T>
    implements IComponentResolver {
        private static final long serialVersionUID = 1L;
        private final String anchor;
        public static boolean autoEnable = true;

        public <C extends Page> AutolinkBookmarkablePageLink(String id, Class<C> pageClass, PageParameters parameters, String anchor) {
            super(id, pageClass, parameters);
            this.anchor = anchor;
            this.setAutoEnable(autoEnable);
            this.add(new DisabledAttributeLinkBehavior());
        }

        @Override
        protected CharSequence getURL() {
            Object url = super.getURL();
            if (this.anchor != null) {
                url = (CharSequence)url + this.anchor;
            }
            return url;
        }

        @Override
        public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
            return this.getParent().get(tag.getId());
        }
    }

    public static abstract class AbstractAutolinkResolverDelegate
    implements IAutolinkResolverDelegate {
        protected final Component newPackageResourceReferenceAutoComponent(String autoId, PathInfo pathInfo, String attribute) {
            MarkupContainer container = pathInfo.getContainer();
            if (!pathInfo.absolute && pathInfo.path != null && pathInfo.path.length() > 0) {
                MarkupStream markupStream = pathInfo.getMarkupStream();
                Class<? extends Component> clazz = markupStream.getContainerClass();
                if (markupStream.get() instanceof ComponentTag && markupStream.getTag().getMarkupClass() != null) {
                    clazz = markupStream.getTag().getMarkupClass();
                }
                ResourceReferenceAutolink autoLink = new ResourceReferenceAutolink(autoId, clazz, pathInfo.reference, attribute, container);
                if (autoLink.resourceReference != null) {
                    return autoLink;
                }
            }
            return null;
        }
    }
}

