/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.pageStore.crypt.DefaultCrypter;
import org.apache.wicket.pageStore.crypt.ICrypter;
import org.apache.wicket.util.lang.Args;

public class CryptingPageStore
extends DelegatingPageStore {
    private static final MetaDataKey<SessionData> KEY = new MetaDataKey<SessionData>(){};

    public CryptingPageStore(IPageStore delegate) {
        super(delegate);
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    @Override
    public boolean canBeAsynchronous(IPageContext context) {
        this.getSessionData(context);
        return this.getDelegate().canBeAsynchronous(context);
    }

    private SessionData getSessionData(IPageContext context) {
        return context.getSessionData(KEY, () -> new SessionData(this.newCrypter(context)));
    }

    protected ICrypter newCrypter(IPageContext context) {
        return new DefaultCrypter();
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        IManageablePage page = this.getDelegate().getPage(context, id);
        if (page != null) {
            if (!(page instanceof SerializedPage)) {
                throw new WicketRuntimeException("CryptingPageStore expects serialized pages");
            }
            SerializedPage serializedPage = (SerializedPage)page;
            byte[] encrypted = serializedPage.getData();
            byte[] decrypted = this.getSessionData(context).decrypt(encrypted);
            page = new SerializedPage(page.getPageId(), serializedPage.getPageType(), decrypted);
        }
        return page;
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("CryptingPageStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        byte[] decrypted = serializedPage.getData();
        byte[] encrypted = this.getSessionData(context).encrypt(decrypted);
        page = new SerializedPage(page.getPageId(), serializedPage.getPageType(), encrypted);
        this.getDelegate().addPage(context, page);
    }

    private static class SessionData
    implements Serializable {
        private final ICrypter cypter;

        public SessionData(ICrypter crypter) {
            Args.notNull((Object)crypter, (String)"crypter");
            this.cypter = crypter;
        }

        public byte[] encrypt(byte[] decrypted) {
            return this.cypter.encrypt(decrypted);
        }

        public byte[] decrypt(byte[] encrypted) {
            return this.cypter.decrypt(encrypted);
        }
    }
}

