/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.util.LinkedList;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPageStore
extends DelegatingPageStore {
    private static final Logger log = LoggerFactory.getLogger(RequestPageStore.class);
    private static final MetaDataKey<RequestData> KEY = new MetaDataKey<RequestData>(){
        private static final long serialVersionUID = 1L;
    };

    public RequestPageStore(IPageStore delegate) {
        super(delegate);
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        IManageablePage page = this.getRequestData(context).get(id);
        if (page != null) {
            return page;
        }
        return this.getDelegate().getPage(context, id);
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        this.getRequestData(context).add(page);
    }

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        this.getRequestData(context).remove(page);
        this.getDelegate().removePage(context, page);
    }

    @Override
    public void removeAllPages(IPageContext context) {
        this.getRequestData(context).removeAll();
        this.getDelegate().removeAllPages(context);
    }

    @Override
    public void detach(IPageContext context) {
        RequestData requestData = this.getRequestData(context);
        for (IManageablePage page : requestData.pages()) {
            boolean isPageStateless;
            try {
                isPageStateless = page.isPageStateless();
            }
            catch (Exception x) {
                log.warn("An error occurred while checking whether a page is stateless. Assuming it is stateful.", (Throwable)x);
                isPageStateless = false;
            }
            if (isPageStateless) continue;
            this.getDelegate().addPage(context, page);
        }
        requestData.removeAll();
        this.getDelegate().detach(context);
    }

    private RequestData getRequestData(IPageContext context) {
        return context.getRequestData(KEY, () -> new RequestData());
    }

    static class RequestData {
        private LinkedList<IManageablePage> pages = new LinkedList();

        RequestData() {
        }

        public void add(IManageablePage page) {
            this.pages.remove(page);
            this.pages.addLast(page);
        }

        public Iterable<IManageablePage> pages() {
            return this.pages;
        }

        public IManageablePage get(int id) {
            for (IManageablePage page : this.pages) {
                if (page.getPageId() != id) continue;
                return page;
            }
            return null;
        }

        public void remove(IManageablePage page) {
            this.pages.remove(page);
        }

        public void removeAll() {
            this.pages.clear();
        }
    }
}

