/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestLogger
implements IRequestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRequestLogger.class);
    private static MetaDataKey<IRequestLogger.RequestData> REQUEST_DATA = new MetaDataKey<IRequestLogger.RequestData>(){
        private static final long serialVersionUID = 1L;
    };
    private static MetaDataKey<IRequestLogger.SessionData> SESSION_DATA = new MetaDataKey<IRequestLogger.SessionData>(){
        private static final long serialVersionUID = 1L;
    };
    private final AtomicInteger totalCreatedSessions = new AtomicInteger();
    private final AtomicInteger peakSessions = new AtomicInteger();
    private final Map<String, IRequestLogger.SessionData> liveSessions;
    private final AtomicInteger activeRequests = new AtomicInteger();
    private final AtomicInteger peakActiveRequests = new AtomicInteger();
    private IRequestLogger.RequestData[] requestWindow;
    private final Object requestWindowLock = new Object();
    private int indexInWindow = 0;
    private long totalRequestTime = 0L;
    private Date startTimeOfOldestRequest;

    public AbstractRequestLogger() {
        int requestsWindowSize = this.getRequestsWindowSize();
        this.requestWindow = new IRequestLogger.RequestData[requestsWindowSize];
        this.liveSessions = new ConcurrentHashMap<String, IRequestLogger.SessionData>();
    }

    @Override
    public int getCurrentActiveRequestCount() {
        return this.activeRequests.get();
    }

    @Override
    public int getPeakActiveRequestCount() {
        return this.peakActiveRequests.get();
    }

    @Override
    public IRequestLogger.SessionData[] getLiveSessions() {
        Object[] sessions = this.liveSessions.values().toArray(new IRequestLogger.SessionData[0]);
        Arrays.sort(sessions);
        return sessions;
    }

    @Override
    public int getPeakSessions() {
        return this.peakSessions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRequestLogger.RequestData> getRequests() {
        Object object = this.requestWindowLock;
        synchronized (object) {
            IRequestLogger.RequestData[] result = new IRequestLogger.RequestData[this.hasBufferRolledOver() ? this.requestWindow.length : this.indexInWindow];
            this.copyRequestsInOrder(result);
            return Arrays.asList(result);
        }
    }

    private void copyRequestsInOrder(IRequestLogger.RequestData[] copy) {
        int destPos = 0;
        if (this.hasBufferRolledOver()) {
            destPos = this.requestWindow.length - this.indexInWindow;
            System.arraycopy(this.requestWindow, this.indexInWindow, copy, 0, destPos);
        }
        System.arraycopy(this.requestWindow, 0, copy, destPos, this.indexInWindow);
    }

    private boolean hasBufferRolledOver() {
        return this.requestWindow.length > 0 && this.requestWindow[this.requestWindow.length - 1] != null;
    }

    @Override
    public int getTotalCreatedSessions() {
        return this.totalCreatedSessions.get();
    }

    @Override
    public void objectCreated(Object value) {
    }

    @Override
    public void objectRemoved(Object value) {
    }

    @Override
    public void objectUpdated(Object value) {
    }

    @Override
    public void requestTime(long timeTaken) {
        IRequestLogger.RequestData requestdata = RequestCycle.get().getMetaData(REQUEST_DATA);
        if (requestdata != null) {
            if (this.activeRequests.get() > 0) {
                requestdata.setActiveRequest(this.activeRequests.decrementAndGet());
            }
            Session session = Session.exists() ? Session.get() : null;
            String sessionId = session != null ? session.getId() : "N/A";
            requestdata.setSessionId(sessionId);
            Object sessionInfo = this.getSessionInfo(session);
            requestdata.setSessionInfo(sessionInfo);
            long sizeInBytes = -1L;
            if (Application.exists() && Application.get().getRequestLoggerSettings().getRecordSessionSize()) {
                try {
                    sizeInBytes = session != null ? session.getSizeInBytes() : -1L;
                }
                catch (Exception e) {
                    LOG.error("Exception while determining the size of the session in the request logger: " + e.getMessage(), (Throwable)e);
                }
            }
            requestdata.setSessionSize(sizeInBytes);
            requestdata.setTimeTaken(timeTaken);
            this.addRequest(requestdata);
            if (sessionId != null) {
                IRequestLogger.SessionData sessiondata = this.liveSessions.get(sessionId);
                if (sessiondata == null) {
                    sessiondata = RequestCycle.get().getMetaData(SESSION_DATA);
                }
                if (sessiondata == null) {
                    this.sessionCreated(sessionId);
                    sessiondata = this.liveSessions.get(sessionId);
                }
                if (sessiondata != null) {
                    sessiondata.setSessionInfo(sessionInfo);
                    sessiondata.setSessionSize(sizeInBytes);
                    sessiondata.addTimeTaken(timeTaken);
                    RequestCycle.get().setMetaData((MetaDataKey)SESSION_DATA, sessiondata);
                }
            }
        }
    }

    @Override
    public void sessionCreated(String sessionId) {
        this.liveSessions.put(sessionId, new IRequestLogger.SessionData(sessionId));
        if (this.liveSessions.size() > this.peakSessions.get()) {
            this.peakSessions.set(this.liveSessions.size());
        }
        this.totalCreatedSessions.incrementAndGet();
    }

    @Override
    public void sessionDestroyed(String sessionId) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestLogger.SessionData sessionData = this.liveSessions.remove(sessionId);
        if (requestCycle != null) {
            requestCycle.setMetaData((MetaDataKey)SESSION_DATA, sessionData);
        }
    }

    @Override
    public IRequestLogger.RequestData getCurrentRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestLogger.RequestData rd = requestCycle.getMetaData(REQUEST_DATA);
        if (rd == null) {
            rd = new IRequestLogger.RequestData();
            requestCycle.setMetaData((MetaDataKey)REQUEST_DATA, rd);
            int activeCount = this.activeRequests.incrementAndGet();
            if (activeCount > this.peakActiveRequests.get()) {
                this.peakActiveRequests.set(activeCount);
            }
        }
        return rd;
    }

    @Override
    public void performLogging() {
        IRequestLogger.RequestData requestdata = RequestCycle.get().getMetaData(REQUEST_DATA);
        if (requestdata != null) {
            IRequestLogger.SessionData sessiondata = RequestCycle.get().getMetaData(SESSION_DATA);
            this.log(requestdata, sessiondata);
        }
    }

    protected abstract void log(IRequestLogger.RequestData var1, IRequestLogger.SessionData var2);

    private Object getSessionInfo(Session session) {
        if (session instanceof IRequestLogger.ISessionLogInfo) {
            return ((IRequestLogger.ISessionLogInfo)((Object)session)).getSessionInfo();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(IRequestLogger.RequestData rd) {
        this.resizeBuffer();
        Object object = this.requestWindowLock;
        synchronized (object) {
            if (this.requestWindow.length == 0) {
                return;
            }
            IRequestLogger.RequestData old = this.requestWindow[this.indexInWindow];
            this.requestWindow[this.indexInWindow] = rd;
            this.indexInWindow = (this.indexInWindow + 1) % this.requestWindow.length;
            if (old != null) {
                this.startTimeOfOldestRequest = this.requestWindow[this.indexInWindow].getStartDate();
                this.totalRequestTime -= old.getTimeTaken().longValue();
            } else if (this.startTimeOfOldestRequest == null) {
                this.startTimeOfOldestRequest = rd.getStartDate();
            }
            this.totalRequestTime += rd.getTimeTaken().longValue();
        }
    }

    private int getWindowSize() {
        if (this.requestWindow[this.requestWindow.length - 1] == null) {
            return this.indexInWindow;
        }
        return this.requestWindow.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAverageRequestTime() {
        Object object = this.requestWindowLock;
        synchronized (object) {
            int windowSize = this.getWindowSize();
            if (windowSize == 0) {
                return 0L;
            }
            return this.totalRequestTime / (long)windowSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequestsPerMinute() {
        Object object = this.requestWindowLock;
        synchronized (object) {
            int windowSize = this.getWindowSize();
            if (windowSize == 0) {
                return 0L;
            }
            long start = this.startTimeOfOldestRequest.getTime();
            long end = System.currentTimeMillis();
            double diff = end - start;
            return Math.round((double)windowSize / (diff / 60000.0));
        }
    }

    @Override
    public void logEventTarget(IRequestHandler requestHandler) {
        IRequestLogger.RequestData requestData = this.getCurrentRequest();
        if (requestData != null) {
            requestData.setEventTarget(requestHandler);
        }
    }

    @Override
    public void logRequestedUrl(String url) {
        this.getCurrentRequest().setRequestedUrl(url);
    }

    @Override
    public void logResponseTarget(IRequestHandler requestHandler) {
        IRequestLogger.RequestData requestData = this.getCurrentRequest();
        if (requestData != null) {
            requestData.setResponseTarget(requestHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeBuffer() {
        int newCapacity = this.getRequestsWindowSize();
        if (newCapacity == this.requestWindow.length) {
            return;
        }
        IRequestLogger.RequestData[] newRequestWindow = new IRequestLogger.RequestData[newCapacity];
        Object object = this.requestWindowLock;
        synchronized (object) {
            int oldNumberOfElements;
            int oldCapacity = this.requestWindow.length;
            int n = oldNumberOfElements = this.hasBufferRolledOver() ? oldCapacity : this.indexInWindow;
            if (newCapacity > oldCapacity) {
                this.copyRequestsInOrder(newRequestWindow);
                this.indexInWindow = oldNumberOfElements;
                this.requestWindow = newRequestWindow;
            } else if (newCapacity < oldCapacity) {
                IRequestLogger.RequestData[] sortedRequestWindow = new IRequestLogger.RequestData[oldCapacity];
                this.copyRequestsInOrder(sortedRequestWindow);
                int numberOfElementsToCopy = Math.min(newCapacity, oldNumberOfElements);
                int numberOfElementsToSkip = Math.max(0, oldNumberOfElements - numberOfElementsToCopy);
                System.arraycopy(sortedRequestWindow, numberOfElementsToSkip, newRequestWindow, 0, numberOfElementsToCopy);
                this.indexInWindow = numberOfElementsToCopy >= newCapacity ? 0 : numberOfElementsToCopy;
                this.requestWindow = newRequestWindow;
            }
        }
    }

    protected String formatDate(Date date) {
        Args.notNull((Object)date, (String)"date");
        Calendar cal = Calendar.getInstance(Time.GMT);
        StringBuilder buf = new StringBuilder(32);
        cal.setTimeInMillis(date.getTime());
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int millis = cal.get(14);
        buf.append(year);
        buf.append('-');
        buf.append(String.format("%02d", month));
        buf.append('-');
        buf.append(String.format("%02d", day));
        buf.append(' ');
        buf.append(String.format("%02d", hours));
        buf.append(':');
        buf.append(String.format("%02d", minutes));
        buf.append(':');
        buf.append(String.format("%02d", seconds));
        buf.append(',');
        buf.append(String.format("%03d", millis));
        return buf.toString();
    }

    private int getRequestsWindowSize() {
        int requestsWindowSize = 0;
        if (Application.exists()) {
            requestsWindowSize = Application.get().getRequestLoggerSettings().getRequestsWindowSize();
        }
        return requestsWindowSize;
    }
}

