/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response.filter;

import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAndClientTimeFilter
implements IResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ServerAndClientTimeFilter.class);

    @Override
    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int headIndex = responseBuffer.indexOf("<head>");
        int bodyIndex = responseBuffer.indexOf("</body>");
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        if (headIndex != -1 && bodyIndex != -1) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("clienttime", "' + (new Date().getTime() - clientTimeVariable)/1000 +  's");
            map.put("servertime", (double)timeTaken / 1000.0 + "s");
            AppendingStringBuffer defaultValue = new AppendingStringBuffer(128);
            defaultValue.append("Server parsetime: ");
            defaultValue.append((double)timeTaken / 1000.0);
            defaultValue.append("s, Client parsetime: ' + (new Date().getTime() - clientTimeVariable)/1000 +  's");
            String txt = Application.get().getResourceSettings().getLocalizer().getString("ServerAndClientTimeFilter.statustext", null, Model.ofMap(map), defaultValue.toString());
            AppendingStringBuffer endScript = new AppendingStringBuffer(150);
            endScript.append("\n").append("<script type=\"text/javascript\">\n/*<![CDATA[*/\n");
            endScript.append("\nwindow.defaultStatus='");
            endScript.append(txt);
            endScript.append("';\n").append("\n/*]]>*/\n</script>\n").append("\n");
            responseBuffer.insert(bodyIndex - 1, (Object)endScript);
            responseBuffer.insert(headIndex + 6, "\n<script type=\"text/javascript\">\n/*<![CDATA[*/\n\nvar clientTimeVariable = new Date().getTime();\n\n/*]]>*/\n</script>\n\n");
        }
        log.info(timeTaken + "ms server time taken for request " + RequestCycle.get().getRequest().getUrl() + " response size: " + responseBuffer.length());
        return responseBuffer;
    }
}

