/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.image.resource.LocalizedImageResource;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;

public class Image
extends WebComponent
implements IRequestListener {
    private static final long serialVersionUID = 1L;
    private final LocalizedImageResource localizedImageResource = new LocalizedImageResource(this);
    private final List<LocalizedImageResource> localizedImageResources = new ArrayList<LocalizedImageResource>();
    private List<String> xValues = null;
    private List<String> sizes = null;
    private CrossOrigin crossOrigin = null;

    protected Image(String id) {
        super(id);
    }

    public Image(String id, ResourceReference resourceReference, ResourceReference ... resourceReferences) {
        this(id, resourceReference, (PageParameters)null, resourceReferences);
    }

    public Image(String id, ResourceReference resourceReference, PageParameters resourceParameters, ResourceReference ... resourceReferences) {
        super(id);
        this.setImageResourceReference(resourceReference, resourceParameters);
        this.setImageResourceReferences(resourceParameters, resourceReferences);
    }

    public Image(String id, IResource imageResource, IResource ... imageResources) {
        super(id);
        this.setImageResource(imageResource);
        this.setImageResources(imageResources);
    }

    public Image(String id, IModel<?> model) {
        super(id, model);
    }

    public Image(String id, String string) {
        this(id, new Model<String>(string));
    }

    @Override
    public boolean rendersPage() {
        return false;
    }

    @Override
    public void onRequest() {
        this.localizedImageResource.onResourceRequested(null);
        for (LocalizedImageResource localizedImageResource : this.localizedImageResources) {
            localizedImageResource.onResourceRequested(null);
        }
    }

    public void setImageResource(IResource imageResource) {
        if (imageResource != null) {
            this.localizedImageResource.setResource(imageResource);
        }
    }

    public void setImageResources(IResource ... imageResources) {
        this.localizedImageResources.clear();
        for (IResource imageResource : imageResources) {
            LocalizedImageResource localizedImageResource = new LocalizedImageResource(this);
            localizedImageResource.setResource(imageResource);
            this.localizedImageResources.add(localizedImageResource);
        }
    }

    public void setImageResourceReference(ResourceReference resourceReference) {
        this.setImageResourceReference(resourceReference, null);
    }

    public void setImageResourceReference(ResourceReference resourceReference, PageParameters parameters) {
        if (this.localizedImageResource != null) {
            if (parameters != null) {
                this.localizedImageResource.setResourceReference(resourceReference, parameters);
            } else {
                this.localizedImageResource.setResourceReference(resourceReference);
            }
        }
    }

    public void setImageResourceReferences(PageParameters parameters, ResourceReference ... resourceReferences) {
        this.localizedImageResources.clear();
        for (ResourceReference resourceReference : resourceReferences) {
            LocalizedImageResource localizedImageResource = new LocalizedImageResource(this);
            if (parameters != null) {
                localizedImageResource.setResourceReference(resourceReference, parameters);
            } else {
                localizedImageResource.setResourceReference(resourceReference);
            }
            this.localizedImageResources.add(localizedImageResource);
        }
    }

    public void setXValues(String ... values) {
        if (this.xValues == null) {
            this.xValues = new ArrayList<String>();
        } else {
            this.xValues.clear();
        }
        this.xValues.addAll(Arrays.asList(values));
    }

    public void removeXValues() {
        if (this.xValues != null) {
            this.xValues.clear();
        }
    }

    public void setSizes(String ... sizes) {
        if (this.sizes == null) {
            this.sizes = new ArrayList<String>();
        } else {
            this.sizes.clear();
        }
        this.sizes.addAll(Arrays.asList(sizes));
    }

    public void removeSizes() {
        if (this.sizes != null) {
            this.sizes.clear();
        }
    }

    @Override
    public Component setDefaultModel(IModel<?> model) {
        for (LocalizedImageResource localizedImageResource : this.localizedImageResources) {
            localizedImageResource.setResourceReference(null);
            localizedImageResource.setResource(null);
        }
        this.localizedImageResource.setResourceReference(null);
        this.localizedImageResource.setResource(null);
        return super.setDefaultModel(model);
    }

    protected IResource getImageResource() {
        return this.localizedImageResource.getResource();
    }

    protected ResourceReference getImageResourceReference() {
        return this.localizedImageResource.getResourceReference();
    }

    @Override
    protected IModel<?> initModel() {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if ("source".equals(tag.getName())) {
            this.buildSrcSetAttribute(tag);
            tag.remove("src");
        } else {
            this.checkComponentTag(tag, "img");
            String srcAttribute = this.buildSrcAttribute(tag);
            this.buildSrcSetAttribute(tag);
            tag.put("src", srcAttribute);
        }
        this.buildSizesAttribute(tag);
        CrossOrigin crossOrigin = this.getCrossOrigin();
        if (crossOrigin != null && CrossOrigin.NO_CORS != crossOrigin) {
            tag.put("crossOrigin", crossOrigin.getRealName());
        }
    }

    protected void buildSrcSetAttribute(ComponentTag tag) {
        int srcSetPosition = 0;
        for (LocalizedImageResource localizedImageResource : this.localizedImageResources) {
            localizedImageResource.setSrcAttribute(tag);
            if (this.shouldAddAntiCacheParameter()) {
                this.addAntiCacheParameter(tag);
            }
            String srcset = tag.getAttribute("srcset");
            String xValue = "";
            if (this.xValues != null) {
                xValue = this.xValues.size() > srcSetPosition && this.xValues.get(srcSetPosition) != null ? " " + this.xValues.get(srcSetPosition) : "";
            }
            tag.put("srcset", (String)(srcset != null ? srcset + ", " : "") + tag.getAttribute("src") + xValue);
            ++srcSetPosition;
        }
    }

    protected String buildSrcAttribute(ComponentTag tag) {
        ResourceReference resourceReference;
        IResource resource = this.getImageResource();
        if (resource != null) {
            this.localizedImageResource.setResource(resource);
        }
        if ((resourceReference = this.getImageResourceReference()) != null) {
            this.localizedImageResource.setResourceReference(resourceReference);
        }
        this.localizedImageResource.setSrcAttribute(tag);
        if (this.shouldAddAntiCacheParameter()) {
            this.addAntiCacheParameter(tag);
        }
        return tag.getAttribute("src");
    }

    protected void buildSizesAttribute(ComponentTag tag) {
        if (this.sizes == null) {
            return;
        }
        Object sizes = "";
        for (String size : this.sizes) {
            sizes = (String)sizes + size + ",";
        }
        int lastIndexOf = ((String)sizes).lastIndexOf(",");
        if (lastIndexOf != -1) {
            sizes = ((String)sizes).substring(0, lastIndexOf);
        }
        if (!((String)sizes).isEmpty()) {
            tag.put("sizes", (CharSequence)sizes);
        }
    }

    protected boolean shouldAddAntiCacheParameter() {
        return this.getRequestCycle().find(IPartialPageRequestHandler.class).isPresent();
    }

    protected void addAntiCacheParameter(ComponentTag tag) {
        Object url;
        url = (String)url + (((String)(url = tag.getAttributes().getString("src"))).contains("?") ? "&" : "?");
        url = (String)url + "antiCache=" + System.currentTimeMillis();
        tag.put("src", (CharSequence)url);
    }

    @Override
    protected boolean getStatelessHint() {
        boolean stateless = (this.getImageResource() == null || this.getImageResource() == this.localizedImageResource.getResource()) && this.localizedImageResource.isStateless();
        boolean statelessList = false;
        for (LocalizedImageResource localizedImageResource : this.localizedImageResources) {
            if (!localizedImageResource.isStateless()) continue;
            statelessList = true;
        }
        return stateless || statelessList;
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
    }

    @Override
    public boolean canCallListener() {
        if (this.isVisibleInHierarchy()) {
            return true;
        }
        return super.canCallListener();
    }

    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    public void setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
    }
}

