/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.datetime.markup.html.basic;

import org.apache.wicket.Component;
import org.apache.wicket.datetime.DateConverter;
import org.apache.wicket.datetime.PatternDateConverter;
import org.apache.wicket.datetime.StyleDateConverter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class DateLabel
extends Label {
    private static final long serialVersionUID = 1L;
    private String after;
    private String before;
    private final DateConverter converter;

    public static DateLabel forDatePattern(String id, IModel model, String datePattern) {
        return new DateLabel(id, model, new PatternDateConverter(datePattern, true));
    }

    public static DateLabel forDatePattern(String id, String datePattern) {
        return DateLabel.forDatePattern(id, null, datePattern);
    }

    public static DateLabel forDateStyle(String id, IModel model, String dateStyle) {
        return new DateLabel(id, model, new StyleDateConverter(dateStyle, true));
    }

    public static DateLabel forDateStyle(String id, String dateStyle) {
        return DateLabel.forDateStyle(id, null, dateStyle);
    }

    public static DateLabel forShortStyle(String id) {
        return DateLabel.forShortStyle(id, null);
    }

    public static DateLabel forShortStyle(String id, IModel model) {
        return new DateLabel(id, model, new StyleDateConverter(true));
    }

    public static DateLabel withConverter(String id, DateConverter converter) {
        return DateLabel.withConverter(id, null, converter);
    }

    public static DateLabel withConverter(String id, IModel model, DateConverter converter) {
        return new DateLabel(id, model, converter);
    }

    public DateLabel(String id, DateConverter converter) {
        this(id, null, converter);
    }

    public DateLabel(String id, IModel model, DateConverter converter) {
        super(id, model);
        if (converter == null) {
            throw new IllegalStateException("converter may not be null");
        }
        converter.setComponent((Component)this);
        this.converter = converter;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public IConverter getConverter(Class clazz) {
        return this.converter;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String s = this.getModelObjectAsString();
        if (this.before != null) {
            s = this.before + s;
        }
        if (this.after != null) {
            s = s + this.after;
        }
        this.replaceComponentTagBody(markupStream, openTag, s);
    }
}

