/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.StringHeaderContributor;
import org.apache.wicket.extensions.yui.YuiLib;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public abstract class AbstractCalendar
extends WebComponent {
    public static final DateFormat FORMAT_DATE = new SimpleDateFormat("MM/dd/yyyy");
    public static final DateFormat FORMAT_PAGEDATE = new SimpleDateFormat("MM/yyyy");
    private static final long serialVersionUID = 1L;

    public AbstractCalendar(String id) {
        this(id, true);
    }

    public AbstractCalendar(String id, boolean contributeDependencies) {
        super(id);
        this.setOutputMarkupId(true);
        if (contributeDependencies) {
            this.contributeDependencies();
        }
        this.add((IBehavior)new StringHeaderContributor((IModel)new LoadableDetachableModel(){
            private static final long serialVersionUID = 1L;

            protected Object load() {
                String markupId = AbstractCalendar.this.getMarkupId();
                String javascriptId = AbstractCalendar.this.getJavascriptId();
                String javascriptWidgetId = AbstractCalendar.this.getJavascriptWidgetId();
                StringBuffer b = new StringBuffer();
                b.append("<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
                b.append("YAHOO.namespace(\"wicket\");\nfunction init");
                b.append(javascriptId);
                b.append("() {\n");
                b.append("  ");
                b.append(javascriptWidgetId);
                b.append(" = new YAHOO.widget.Calendar(\"");
                b.append(javascriptId);
                b.append("\",\"");
                b.append(markupId);
                Properties p = new Properties();
                AbstractCalendar.this.configureWidgetProperties(p);
                b.append("\", { ");
                Iterator<Map.Entry<Object, Object>> i = p.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<Object, Object> entry = i.next();
                    b.append(entry.getKey());
                    Object value = entry.getValue();
                    if (value instanceof CharSequence) {
                        b.append(":\"");
                        b.append(value);
                        b.append("\"");
                    } else if (value instanceof CharSequence[]) {
                        b.append(":[");
                        CharSequence[] valueArray = (CharSequence[])value;
                        for (int j = 0; j < valueArray.length; ++j) {
                            CharSequence tmpValue = valueArray[j];
                            b.append("\"");
                            b.append(tmpValue);
                            b.append("\"");
                            if (j >= valueArray.length - 1) continue;
                            b.append(",");
                        }
                        b.append("]");
                    } else {
                        b.append(":");
                        b.append(value);
                    }
                    if (!i.hasNext()) continue;
                    b.append(",");
                }
                b.append(" });\n");
                AbstractCalendar.this.appendToInit(markupId, javascriptId, javascriptWidgetId, b);
                b.append("  ");
                b.append(javascriptWidgetId);
                b.append(".render();\n");
                b.append("}\n");
                b.append("YAHOO.util.Event.addListener(window, \"load\", init");
                b.append(javascriptId);
                b.append(");");
                b.append("\n/*-->]]>*/</script>\n");
                return b;
            }
        }));
    }

    public final String getJavascriptId() {
        return this.getMarkupId() + "Js";
    }

    public final String getJavascriptWidgetId() {
        return "YAHOO.wicket." + this.getJavascriptId();
    }

    private void contributeDependencies() {
        this.add((IBehavior)HeaderContributor.forJavaScript((Class)YuiLib.class, (String)"yahoo.js"));
        this.add((IBehavior)HeaderContributor.forJavaScript((Class)YuiLib.class, (String)"event.js"));
        this.add((IBehavior)HeaderContributor.forJavaScript((Class)YuiLib.class, (String)"dom.js"));
        this.add((IBehavior)HeaderContributor.forJavaScript((Class)AbstractCalendar.class, (String)"calendar.js"));
        this.add((IBehavior)HeaderContributor.forCss((Class)AbstractCalendar.class, (String)"assets/calendar.css"));
    }

    protected void appendToInit(String markupId, String javascriptId, String javascriptWidgetId, StringBuffer b) {
    }

    protected void configureWidgetProperties(Map widgetProperties) {
    }
}

